
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    fat = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fat")
    vitamin_b3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b3")
    fiber = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fiber")

    # Set objective function
    obj = (6 * fat * fat + 3 * fat * vitamin_b3 + 8 * fat * fiber +
           4 * vitamin_b3 * vitamin_b3 + 3 * vitamin_b3 * fiber +
           9 * fiber * fiber + 8 * fat + 8 * vitamin_b3 + 8 * fiber)
    m.setObjective(obj, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(8 * vitamin_b3 + 8 * fiber >= 14, "c1")
    m.addConstr(2 * fat + 8 * vitamin_b3 + 8 * fiber >= 14, "c2")
    m.addConstr(4 * vitamin_b3 * vitamin_b3 + 1 * fiber * fiber >= 5, "c3")
    m.addConstr(5 * fat * fat + 1 * fiber * fiber >= 7, "c4")
    m.addConstr(5 * fat + 4 * vitamin_b3 + 1 * fiber >= 7, "c5")
    m.addConstr(7 * fat - 5 * fiber >= 0, "c6")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Fat: %g' % fat.x)
        print('Vitamin B3: %g' % vitamin_b3.x)
        print('Fiber: %g' % fiber.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
