
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, name="grams_of_fat", vtype=gurobi.GRB.CONTINUOUS)
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, name="milligrams_of_vitamin_B3", vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, name="grams_of_fiber", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(6*x0**2 + 3*x0*x1 + 8*x0*x2 + 4*x1**2 + 3*x1*x2 + 9*x2**2 + 8*x0 + 8*x1 + 8*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(2*x0 + 8*x1 + 8*x2 >= 14, name="cardiovascular_support_index")
    model.addConstr(5*x0 + 4*x1 + x2 >= 7, name="muscle_growth_index")
    model.addConstr(4*x1**2 + x2**2 >= 5, name="muscle_growth_index_squared_terms_1")
    model.addConstr(5*x0**2 + x2**2 >= 7, name="muscle_growth_index_squared_terms_2")
    model.addConstr(7*x0 - 5*x2 >= 0, name="additional_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Grams of fat: ", x0.varValue)
        print("Milligrams of vitamin B3: ", x1.varValue)
        print("Grams of fiber: ", x2.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
