
from gurobipy import Model, GRB

# Create a new model
m = Model("carbohydrate_optimization")

# Create variables
potatoes = m.addVar(vtype=GRB.INTEGER, name="potatoes")
bananas = m.addVar(vtype=GRB.CONTINUOUS, name="bananas")

# Set objective function
m.setObjective(6 * potatoes + 7 * bananas, GRB.MINIMIZE)

# Add constraints
m.addConstr(2 * potatoes + 12 * bananas >= 39, "carbohydrate_minimum")
m.addConstr(2 * potatoes + 12 * bananas <= 61, "carbohydrate_maximum")  # Added upper bound constraint
m.addConstr(-5 * potatoes + 7 * bananas >= 0, "potatoes_bananas_ratio")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Potatoes: {potatoes.x}")
    print(f"  Bananas: {bananas.x}")
    print(f"  Objective value: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

