
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
potatoes = m.addVar(vtype=GRB.INTEGER, name="potatoes", lb=0)
bananas = m.addVar(vtype=GRB.CONTINUOUS, name="bananas", lb=0)

# Objective function
m.setObjective(6*potatoes + 7*bananas, GRB.MINIMIZE)

# Constraints
m.addConstr(2*potatoes + 12*bananas >= 39, "carb_min")
m.addConstr(2*potatoes + 12*bananas <= 91, "carb_max")
m.addConstr(-5*potatoes + 7*bananas >= 0, "balance")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Potatoes: {potatoes.x}")
    print(f"Bananas: {bananas.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
