
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
potatoes = model.addVar(name="potatoes", vtype=gurobi.GRB.INTEGER)
bananas = model.addVar(name="bananas")

# Objective function: Minimize 6 * potatoes + 7 * bananas
model.setObjective(6 * potatoes + 7 * bananas, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(2 * potatoes + 12 * bananas >= 39, name="carbohydrates_min")
model.addConstr(2 * potatoes + 12 * bananas <= 91, name="carbohydrates_max")
model.addConstr(-5 * potatoes + 7 * bananas >= 0, name="potatoes_bananas_balance")

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Potatoes: {potatoes.varValue}")
    print(f"Bananas: {bananas.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("The model is infeasible or unbounded.")
