
from gurobipy import Model, GRB

# Create a new model
model = Model("Work Hour Optimization")

# Create variables
bill_hours = model.addVar(lb=0, name="bill_hours")
mary_hours = model.addVar(lb=0, name="mary_hours")
george_hours = model.addVar(lb=0, name="george_hours")
dale_hours = model.addVar(lb=0, name="dale_hours")

# Set objective function
model.setObjective(5*bill_hours**2 + 5*bill_hours*mary_hours + 1*bill_hours*george_hours + 4*bill_hours*dale_hours + 8*mary_hours**2 + 1*mary_hours*dale_hours + 4*george_hours**2 + 1*george_hours*dale_hours + 6*dale_hours**2 + 1*mary_hours + 1*george_hours + 7*dale_hours, GRB.MAXIMIZE)

# Add constraints
model.addConstr(15*bill_hours + 4*george_hours >= 47, "c1")
model.addConstr(15*bill_hours**2 + 9*dale_hours**2 >= 30, "c2")
model.addConstr(5*mary_hours + 4*george_hours >= 19, "c3")
model.addConstr(15*bill_hours + 5*mary_hours >= 50, "c4")
model.addConstr(15*bill_hours + 4*george_hours + 9*dale_hours >= 38, "c5")
model.addConstr(5*mary_hours + 4*george_hours + 9*dale_hours >= 38, "c6")
model.addConstr(15*bill_hours + 4*george_hours + 9*dale_hours >= 49, "c7")
model.addConstr(5*mary_hours + 4*george_hours + 9*dale_hours >= 49, "c8")
model.addConstr(1*bill_hours + 10*dale_hours >= 29, "c9")
model.addConstr(7*bill_hours + 12*mary_hours >= 59, "c10")
model.addConstr(12*mary_hours + 13*george_hours >= 35, "c11")
model.addConstr(7*bill_hours**2 + 13*george_hours**2 >= 41, "c12")
model.addConstr(13*george_hours**2 + 11*dale_hours**2 >= 31, "c13")
model.addConstr(7*bill_hours**2 + 12*mary_hours**2 + 11*dale_hours**2 >= 40, "c14")
model.addConstr(4*george_hours + 9*dale_hours <= 121, "c15")
model.addConstr(5*mary_hours + 9*dale_hours <= 142, "c16")
model.addConstr(15*bill_hours**2 + 4*george_hours**2 <= 80, "c17")
model.addConstr(15*bill_hours + 5*mary_hours + 9*dale_hours <= 63, "c18")
model.addConstr(15*bill_hours + 5*mary_hours + 4*george_hours + 9*dale_hours <= 63, "c19")
model.addConstr(1*bill_hours**2 + 14*george_hours**2 <= 164, "c20")
model.addConstr(1*bill_hours + 10*dale_hours <= 252, "c21")
model.addConstr(1*bill_hours + 14*george_hours + 10*dale_hours <= 261, "c22")
model.addConstr(1*bill_hours + 13*mary_hours + 14*george_hours <= 232, "c23")
model.addConstr(1*bill_hours + 13*mary_hours + 14*george_hours + 10*dale_hours <= 232, "c24")
model.addConstr(12*mary_hours + 11*dale_hours <= 158, "c25")
model.addConstr(7*bill_hours + 13*george_hours <= 84, "c26")
model.addConstr(13*george_hours + 11*dale_hours <= 215, "c27")
model.addConstr(7*bill_hours + 11*dale_hours <= 296, "c28")
model.addConstr(7*bill_hours + 12*mary_hours <= 220, "c29")
model.addConstr(12*mary_hours**2 + 13*george_hours**2 <= 162, "c30")
model.addConstr(7*bill_hours + 12*mary_hours + 13*george_hours + 11*dale_hours <= 162, "c31")
model.addConstr(13*bill_hours**2 + 1*mary_hours**2 <= 70, "c32")
model.addConstr(17*george_hours + 12*dale_hours <= 62, "c33")
model.addConstr(13*bill_hours**2 + 1*mary_hours**2 + 17*george_hours**2 <= 80, "c34")
model.addConstr(1*mary_hours + 17*george_hours + 12*dale_hours <= 48, "c35")
model.addConstr(13*bill_hours + 1*mary_hours + 17*george_hours + 12*dale_hours <= 48, "c36")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Bill Hours: %g' % bill_hours.x)
    print('Mary Hours: %g' % mary_hours.x)
    print('George Hours: %g' % george_hours.x)
    print('Dale Hours: %g' % dale_hours.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", model.status)

