
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="hours_worked_by_Bill", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x1 = m.addVar(name="hours_worked_by_Mary", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x2 = m.addVar(name="hours_worked_by_George", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x3 = m.addVar(name="hours_worked_by_Dale", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)

# Objective function
m.setObjective(5*x0**2 + 5*x0*x1 + x0*x2 + 4*x0*x3 + 8*x1**2 + x1*x3 + 4*x2**2 + x2*x3 + 6*x3**2 + x1 + x2 + 7*x3, gp.GRB.MAXIMIZE)

# Constraints
# Individual scores
m.addConstr(x0 == 15, name="Bill_organization_score")
m.addConstr(x0 * 1 <= 212, name="Bill_productivity_rating")
m.addConstr(x0 * 7 <= 320, name="Bill_paperwork_competence_rating")
m.addConstr(x0 * 13 <= 153, name="Bill_computer_competence_rating")

m.addConstr(x1 == 5, name="Mary_organization_score")
m.addConstr(x1 * 13 <= 304, name="Mary_productivity_rating")
m.addConstr(x1 * 12 <= 320, name="Mary_paperwork_competence_rating")
m.addConstr(x1 * 1 <= 153, name="Mary_computer_competence_rating")

m.addConstr(x2 == 4, name="George_organization_score")
m.addConstr(x2 * 14 <= 304, name="George_productivity_rating")
m.addConstr(x2 * 13 <= 320, name="George_paperwork_competence_rating")
m.addConstr(x2 * 17 <= 153, name="George_computer_competence_rating")

m.addConstr(x3 == 9, name="Dale_organization_score")
m.addConstr(x3 * 10 <= 304, name="Dale_productivity_rating")
m.addConstr(x3 * 11 <= 320, name="Dale_paperwork_competence_rating")
m.addConstr(x3 * 12 <= 153, name="Dale_computer_competence_rating")

# Organization score constraints
m.addConstr(15*x0 + 4*x2 >= 47, name="org_score_Bill_George")
m.addConstr(15*x0 + 81*x3 >= 30, name="org_score_Bill_Dale")
m.addConstr(5*x1 + 4*x2 >= 19, name="org_score_Mary_George")
m.addConstr(15*x0 + 5*x1 >= 50, name="org_score_Bill_Mary")
m.addConstr(15*x0 + 4*x2 + 9*x3 >= 38, name="org_score_Bill_George_Dale")
m.addConstr(5*x1 + 4*x2 + 9*x3 >= 38, name="org_score_Mary_George_Dale")
m.addConstr(15*x0 + 4*x2 + 9*x3 >= 49, name="org_score_Bill_George_Dale_2")
m.addConstr(5*x1 + 4*x2 + 9*x3 >= 49, name="org_score_Mary_George_Dale_2")

# Productivity rating constraints
m.addConstr(x0 + 10*x3 >= 29, name="productivity_Bill_Dale")

# Paperwork competence rating constraints
m.addConstr(7*x0 + 12*x1 >= 59, name="paperwork_Bill_Mary")
m.addConstr(12*x1 + 13*x2 >= 35, name="paperwork_Mary_George")
m.addConstr(49*x0 + 169*x2 >= 41, name="paperwork_Bill_George")
m.addConstr(169*x2 + 121*x3 >= 31, name="paperwork_George_Dale")
m.addConstr(49*x0 + 144*x1 + 121*x3 >= 40, name="paperwork_Bill_Mary_Dale")

# Organization score upper bounds
m.addConstr(4*x2 + 9*x3 <= 121, name="org_score_George_Dale_ub")
m.addConstr(5*x1 + 9*x3 <= 142, name="org_score_Mary_Dale_ub")
m.addConstr(225*x0 + 16*x2 <= 80, name="org_score_Bill_George_ub")
m.addConstr(15*x0 + 5*x1 + 9*x3 <= 63, name="org_score_Bill_Mary_Dale_ub")
m.addConstr(15*x0 + 5*x1 + 4*x2 + 9*x3 <= 63, name="org_score_all_ub")

# Productivity rating upper bounds
m.addConstr(x0 * 1 + x2 * 14 <= 164, name="productivity_Bill_George_ub")
m.addConstr(x0 + 10*x3 <= 252, name="productivity_Bill_Dale_ub")
m.addConstr(x0 + x2 * 14 + 10*x3 <= 261, name="productivity_Bill_George_Dale_ub")
m.addConstr(x0 + 13*x1 + 14*x2 <= 232, name="productivity_Bill_Mary_George_ub")
m.addConstr(x0 + 13*x1 + 14*x2 + 10*x3 <= 232, name="productivity_all_ub")

# Paperwork competence rating upper bounds
m.addConstr(12*x1 + 9*x3 <= 158, name="paperwork_Mary_Dale_ub")
m.addConstr(7*x0 + 13*x2 <= 84, name="paperwork_Bill_George_ub")
m.addConstr(13*x2 + 11*x3 <= 215, name="paperwork_George_Dale_ub")
m.addConstr(7*x0 + 11*x3 <= 296, name="paperwork_Bill_Dale_ub")
m.addConstr(7*x0 + 12*x1 <= 220, name="paperwork_Bill_Mary_ub")
m.addConstr(144*x1 + 169*x2 <= 162, name="paperwork_Mary_George_ub")
m.addConstr(7*x0 + 12*x1 + 13*x2 + 11*x3 <= 162, name="paperwork_all_ub")

# Computer competence rating constraints and upper bounds
m.addConstr(169*x0 + 144*x1 <= 70, name="computer_Bill_Mary_ub")
m.addConstr(17*x2 + 12*x3 <= 62, name="computer_George_Dale_ub")
m.addConstr(169*x0 + 144*x1 + 289*x2 <= 80, name="computer_all_ub")
m.addConstr(17*x2 + 12*x3 + 144*x1 <= 48, name="computer_Mary_George_Dale_ub")
m.addConstr(13*x0 + 144*x1 + 17*x2 + 12*x3 <= 48, name="computer_all_ub_2")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Bill: ", x0.varValue)
    print("Hours worked by Mary: ", x1.varValue)
    print("Hours worked by George: ", x2.varValue)
    print("Hours worked by Dale: ", x3.varValue)
else:
    print("The model is infeasible.")
