
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
knishes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="knishes")
apples = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apples")
chicken_drumsticks = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_drumsticks")

# Set objective function
m.setObjective(8.01 * knishes**2 + 9.79 * knishes * apples + 4.17 * apples * chicken_drumsticks + 4.92 * apples + 2.03 * chicken_drumsticks, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3 * apples + 19 * chicken_drumsticks >= 46, "healthiness_constraint1")
m.addConstr(26 * knishes + 3 * apples + 19 * chicken_drumsticks >= 46, "healthiness_constraint2")
m.addConstr(-4 * knishes + 5 * chicken_drumsticks >= 0, "constraint3")


# Optimize model
m.optimize()

# Check if a solution was found
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective value:', m.objVal)
    print('knishes:', knishes.x)
    print('apples:', apples.x)
    print('chicken_drumsticks:', chicken_drumsticks.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status:', m.status)

