
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(name="knishes", lb=0)  # Number of knishes
x1 = m.addVar(name="apples", lb=0)   # Quantity of apples
x2 = m.addVar(name="chicken_drumsticks", lb=0)  # Quantity of chicken drumsticks

# Objective function
m.setObjective(8.01*x0**2 + 9.79*x0*x1 + 4.17*x1*x2 + 4.92*x1 + 2.03*x2, GRB.MINIMIZE)

# Constraints
m.addConstr(3*x1 + 19*x2 >= 46, name="apples_and_chicken_healthiness")
m.addConstr(26*x0 + 3*x1 + 19*x2 >= 46, name="total_healthiness")
m.addConstr(-4*x0 + 5*x2 >= 0, name="knishes_and_chicken_relation")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Knishes: {x0.x}")
    print(f"Apples: {x1.x}")
    print(f"Chicken Drumsticks: {x2.x}")
else:
    print("No optimal solution found.")
