
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
knishes = m.addVar(lb=0, name="knishes", vtype=gp.GRB.CONTINUOUS)
apples = m.addVar(lb=0, name="apples", vtype=gp.GRB.CONTINUOUS)
chicken_drumsticks = m.addVar(lb=0, name="chicken_drumsticks", vtype=gp.GRB.CONTINUOUS)

# Objective function
m.setObjective(8.01 * knishes**2 + 9.79 * knishes * apples + 4.17 * apples * chicken_drumsticks + 4.92 * apples + 2.03 * chicken_drumsticks, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(3 * apples + 19 * chicken_drumsticks >= 46, name="health_apples_chicken")
m.addConstr(26 * knishes + 3 * apples + 19 * chicken_drumsticks >= 46, name="health_all")
m.addConstr(-4 * knishes + 5 * chicken_drumsticks >= 0, name="knishes_chicken_balance")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Knishes: {knishes.varValue}")
    print(f"Apples: {apples.varValue}")
    print(f"Chicken Drumsticks: {chicken_drumsticks.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
