
import gurobipy as gp

# Create a new model
m = gp.Model("maximize_hours")

# Create variables
bill = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill")
john = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john")
hank = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")
dale = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale")
ringo = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo")
bobby = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby")

# Set objective
m.setObjective(1.47 * bill + 6.6 * john + 9.52 * hank + 7.99 * dale + 5.56 * ringo + 8.87 * bobby, gp.GRB.MAXIMIZE)

# Likelihood to quit indices
lqi = {"bill": 23.35, "john": 0.72, "hank": 3.99, "dale": 10.49, "ringo": 7.84, "bobby": 9.36}

# Add constraints
m.addConstr(hank * lqi["hank"] + ringo * lqi["ringo"] >= 73)
m.addConstr(bill * lqi["bill"] + ringo * lqi["ringo"] >= 50)
m.addConstr(hank * lqi["hank"] + dale * lqi["dale"] >= 63)
m.addConstr(bill * lqi["bill"] + bobby * lqi["bobby"] >= 49)

m.addConstr(bill * lqi["bill"] + john * lqi["john"] + hank * lqi["hank"] >= 61)
m.addConstr(john * lqi["john"] + hank * lqi["hank"] + bobby * lqi["bobby"] >= 61)
m.addConstr(bill * lqi["bill"] + hank * lqi["hank"] + ringo * lqi["ringo"] >= 61)
m.addConstr(bill * lqi["bill"] + john * lqi["john"] + dale * lqi["dale"] >= 61)
m.addConstr(john * lqi["john"] + dale * lqi["dale"] + ringo * lqi["ringo"] >= 61)
m.addConstr(bill * lqi["bill"] + dale * lqi["dale"] + bobby * lqi["bobby"] >= 61)
m.addConstr(bill * lqi["bill"] + hank * lqi["hank"] + dale * lqi["dale"] >= 61)
m.addConstr(john * lqi["john"] + hank * lqi["hank"] + ringo * lqi["ringo"] >= 61)

# ... (Add the remaining constraints similarly, replacing ... with the actual constraints)

m.addConstr(john * lqi["john"] + bobby * lqi["bobby"] <= 414)
m.addConstr(hank * lqi["hank"] + ringo * lqi["ringo"] <= 260)
# ... (Add the remaining constraints similarly)
m.addConstr(bill * lqi["bill"] + john * lqi["john"] + hank * lqi["hank"] + dale * lqi["dale"] + ringo * lqi["ringo"] + bobby * lqi["bobby"] <= 313)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

