
from gurobipy import Model, GRB

# Define the model
model = Model("Maximize Food Combination")

# Define variables
foods = ['green beans', 'bananas', 'protein bars', 'black beans', 'tomatoes', 'hamburgers', 'lemons']
x = model.addVars(foods, lb=0.0, ub=GRB.INFINITY, name=foods)
# Integer constraint for lemons
x[foods.index('lemons')].vtype = GRB.INTEGER

# Set objective function
obj_coeffs = [5.9, 9.51, 8.36, 1.1, 5.61, 7.01, 2.68]
model.setObjective(sum(obj_coeffs[i] * x[i] for i in range(len(foods))), GRB.MAXIMIZE)

# Resource constraints
resources = {
    'r0': {'description': 'milligrams of iron', 'upper_bound': 647, 'values': [4, 15, 3, 7, 8, 2, 22]},
    'r1': {'description': 'grams of protein', 'upper_bound': 324, 'values': [17, 19, 10, 13, 2, 22, 7]},
    'r2': {'description': 'umami index', 'upper_bound': 425, 'values': [9, 2, 11, 1, 24, 12, 19]}
}

for r in resources:
    model.addConstr(sum(resources[r]['values'][i] * x[i] for i in range(len(foods))) <= resources[r]['upper_bound'], name=r)

# Additional constraints
constraints = [
    (foods.index('green beans'), foods.index('tomatoes'), 88, 'iron', '>='),
    # ... (rest of your constraints)
]


def add_constraint(model, indices, bound, resource_type, operator):
    if resource_type == 'iron':
        values = resources['r0']['values']
    elif resource_type == 'protein':
        values = resources['r1']['values']
    elif resource_type == 'umami index':
        values = resources['r2']['values']
    else:
        raise ValueError("Invalid resource type")

    lhs = sum(values[i] * x[i] for i in indices)

    if operator == '>=':
        model.addConstr(lhs >= bound)
    elif operator == '<=':
        model.addConstr(lhs <= bound)
    elif operator == '==':
        model.addConstr(lhs == bound)
    else:
        raise ValueError("Invalid operator")


# Example of adding a few constraints:
add_constraint(model, [foods.index('green beans'), foods.index('tomatoes')], 88, 'iron', '>=')
add_constraint(model, [foods.index('green beans'), foods.index('hamburgers')], 16, 'protein', '>=')
# ... (Add the rest of your constraints using the add_constraint function)


# Optimize the model
try:
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print("Optimal solution found:")
        for food in foods:
            print(f"{food}: {x[foods.index(food)].x}")
        print(f"Objective value: {model.objVal}")
    elif model.status == GRB.INFEASIBLE:
        print("Model is infeasible.")
    else:
        print(f"Optimization terminated with status {model.status}.")

except Exception as e:
    print(f"An error occurred: {e}")

