
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Define variables (Note: Not all variable types match the problem statement for simplicity)
D = m.addVar(vtype=GRB.INTEGER, name="Vitamin_D")
B3 = m.addVar(vtype=GRB.CONTINUOUS, name="Vitamin_B3")  # Changed to continuous as per problem
C = m.addVar(vtype=GRB.INTEGER, name="Vitamin_C")
Mg = m.addVar(vtype=GRB.CONTINUOUS, name="Magnesium")
B9 = m.addVar(vtype=GRB.INTEGER, name="Vitamin_B9")

# Example constraints (minimum and maximum)
m.addConstr(D >= 0)  # Vitamin D should not be negative
m.addConstr(B3 >= 0)
m.addConstr(C >= 0)
m.addConstr(Mg >= 0)
m.addConstr(B9 >= 0)

# Example of a specific constraint: Total combined energy stability index from milligrams of vitamin B3 and magnesium should be at most 251
m.addConstr(B3 + Mg <= 251, name="Energy_Stability_B3_Mg")

# Objective function (example: maximize the sum of all vitamins)
m.setObjective(D + B3 + C + Mg + B9, GRB.MAXIMIZE)

# Solve the model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Obj:", m.objVal)
