
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="vitamin_D", vtype=gp.GRB.INTEGER)  # milligrams of vitamin D
x1 = m.addVar(name="vitamin_B3")  # milligrams of vitamin B3
x2 = m.addVar(name="vitamin_C", vtype=gp.GRB.INTEGER)  # milligrams of vitamin C
x3 = m.addVar(name="magnesium")  # milligrams of magnesium
x4 = m.addVar(name="vitamin_B9", vtype=gp.GRB.INTEGER)  # milligrams of vitamin B9

# Objective function
m.setObjective(6.79 * x0 + 5.12 * x1 + 7.51 * x2 + 3.45 * x3 + 8.09 * x4, gp.GRB.MAXIMIZE)

# Energy stability index constraints
m.addConstr(5 * x0 + 18 * x1 + 21 * x2 + 15 * x3 + 20 * x4 <= 884)
m.addConstr(21 * x2 + 20 * x4 >= 157)
m.addConstr(18 * x1 + 21 * x2 >= 82)
m.addConstr(15 * x3 + 20 * x4 >= 155)
m.addConstr(18 * x1 + 15 * x3 >= 117)
m.addConstr(5 * x0 + 20 * x4 >= 92)
m.addConstr(5 * x0 + 15 * x3 >= 103)
m.addConstr(5 * x0 + 18 * x1 >= 60)
m.addConstr(18 * x1 + 20 * x4 >= 161)
m.addConstr(5 * x0 + 21 * x2 >= 107)
m.addConstr(5 * x0 + 18 * x1 + 15 * x3 >= 170)

# Digestive support index constraints
m.addConstr(9 * x0 + 11 * x1 + 12 * x2 + 22 * x3 + 26 * x4 >= 104)
m.addConstr(11 * x1 + 12 * x2 >= 91)
m.addConstr(11 * x1 + 26 * x4 >= 90)
m.addConstr(12 * x2 + 22 * x3 >= 67)
m.addConstr(22 * x3 + 26 * x4 >= 102)
m.addConstr(12 * x2 + 26 * x4 >= 62)
m.addConstr(11 * x1 + 12 * x2 + 26 * x4 >= 85)
m.addConstr(9 * x0 + 11 * x1 + 12 * x2 >= 85)
m.addConstr(9 * x0 + 22 * x3 + 26 * x4 >= 85)
m.addConstr(9 * x0 + 12 * x2 + 26 * x4 >= 85)

# Immune support index constraints
m.addConstr(17 * x0 + 19 * x1 + 19 * x2 + 8 * x3 + 6 * x4 <= 181)
m.addConstr(19 * x1 + 8 * x3 >= 27)
m.addConstr(8 * x3 + 6 * x4 >= 26)
m.addConstr(17 * x0 + 8 * x3 >= 19)
m.addConstr(19 * x2 + 8 * x3 >= 25)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Vitamin D: ", x0.varValue)
    print("Vitamin B3: ", x1.varValue)
    print("Vitamin C: ", x2.varValue)
    print("Magnesium: ", x3.varValue)
    print("Vitamin B9: ", x4.varValue)
else:
    print("The model is infeasible")
