
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
x0 = m.addVar(name="milligrams_of_vitamin_D", lb=0)
x1 = m.addVar(name="milligrams_of_vitamin_E", lb=0)
x2 = m.addVar(name="milligrams_of_vitamin_B2", lb=0)
x3 = m.addVar(name="milligrams_of_calcium", lb=0)

# Objective function
m.setObjective(5.48*x0 + 3.41*x1 + 3.37*x2 + 9.6*x3, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(1.34*x0 + 0.07*x1 + 1.3*x2 + 0.95*x3 <= 155)

# Individual immune support indices are already given as attributes
# and are directly used in other constraints

# Combined immune support index constraints
m.addConstr(0.07*x1 + 0.95*x3 >= 19)
m.addConstr(0.07*x1 + 1.3*x2 >= 21)
m.addConstr(1.34*x0 + 1.3*x2 >= 23)
m.addConstr(0.07*x1 + 1.3*x2 + 0.95*x3 >= 19)
m.addConstr(1.34*x0 + 0.07*x1 + 0.95*x3 >= 19)
m.addConstr(1.34*x0 + 0.07*x1 + 1.3*x2 + 0.95*x3 >= 19)

# Linear constraints
m.addConstr(-3*x1 + 9*x3 >= 0)
m.addConstr(-x1 + 9*x2 >= 0)
m.addConstr(9*x0 - 5*x1 >= 0)

# Upper bound constraints
m.addConstr(1.34*x0 + 0.95*x3 <= 45)
m.addConstr(1.34*x0 + 1.3*x2 + 0.95*x3 <= 107)
m.addConstr(1.34*x0 + 0.07*x1 + 0.95*x3 <= 121)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin D: {x0.varValue}")
    print(f"Milligrams of vitamin E: {x1.varValue}")
    print(f"Milligrams of vitamin B2: {x2.varValue}")
    print(f"Milligrams of calcium: {x3.varValue}")
    print(f"Objective value: {m.objVal}")
else:
    print("No optimal solution found.")
