
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
fat = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fat")
potassium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potassium")
vitamin_c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_c")
calcium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="calcium")

# Set objective function
m.setObjective(3 * fat + 3 * potassium + 7 * vitamin_c + 1 * calcium, gp.GRB.MAXIMIZE)

# Add constraints based on resource attributes
resource_data = {
    'r0': {'description': 'digestive support index', 'upper_bound': 454, 'x0': 17, 'x1': 16, 'x2': 15, 'x3': 2},
    'r1': {'description': 'muscle growth index', 'upper_bound': 235, 'x0': 19, 'x1': 16, 'x2': 19, 'x3': 18},
    'r2': {'description': 'immune support index', 'upper_bound': 527, 'x0': 16, 'x1': 7, 'x2': 8, 'x3': 6},
    'r3': {'description': 'cardiovascular support index', 'upper_bound': 397, 'x0': 9, 'x1': 16, 'x2': 3, 'x3': 17}
}

for resource, data in resource_data.items():
    m.addConstr(data['x0'] * fat + data['x1'] * potassium + data['x2'] * vitamin_c + data['x3'] * calcium <= data['upper_bound'], name=f"{resource}_upper_bound")


# Add additional constraints from the problem description
m.addConstr(17 * fat + 2 * calcium >= 55, "c1")
m.addConstr(16 * potassium + 2 * calcium >= 62, "c2")
m.addConstr(19 * fat + 18 * calcium >= 48, "c3")
m.addConstr(19 * vitamin_c + 18 * calcium >= 37, "c4")
m.addConstr(19 * fat + 16 * potassium + 18 * calcium >= 41, "c5")
m.addConstr(19 * fat + 16 * potassium + 19 * vitamin_c >= 41, "c6")
m.addConstr(9 * fat + 3 * vitamin_c >= 57, "c7")
m.addConstr(9 * fat + 16 * potassium >= 57, "c8")
m.addConstr(16 * potassium + 3 * vitamin_c >= 68, "c9")
m.addConstr(3 * vitamin_c + 17 * calcium >= 40, "c10")
m.addConstr(6 * fat + 8 * vitamin_c - 4 * calcium >= 0, "c11")
m.addConstr(15 * vitamin_c + 2 * calcium <= 360, "c12")
m.addConstr(17 * fat + 16 * potassium <= 446, "c13")
m.addConstr(17 * fat + 2 * calcium <= 335, "c14")
m.addConstr(17 * fat + 15 * vitamin_c + 2 * calcium <= 316, "c15")
m.addConstr(17 * fat + 16 * potassium + 15 * vitamin_c + 2 * calcium <= 316, "c16")
m.addConstr(19 * vitamin_c + 18 * calcium <= 140, "c17")
m.addConstr(19 * fat + 16 * potassium <= 118, "c18")
m.addConstr(16 * potassium + 19 * vitamin_c <= 86, "c19")
m.addConstr(19 * fat + 16 * potassium + 19 * vitamin_c + 18 * calcium <= 86, "c20")
m.addConstr(16 * fat + 8 * vitamin_c <= 405, "c21")
m.addConstr(7 * potassium + 6 * calcium <= 289, "c22")
m.addConstr(7 * potassium + 8 * vitamin_c <= 448, "c23")
m.addConstr(16 * fat + 7 * potassium <= 427, "c24")
m.addConstr(16 * fat + 6 * calcium <= 481, "c25")
m.addConstr(16 * fat + 7 * potassium + 8 * vitamin_c + 6 * calcium <= 481, "c26")
m.addConstr(9 * fat + 17 * calcium <= 283, "c27")
m.addConstr(16 * potassium + 3 * vitamin_c <= 332, "c28")
m.addConstr(9 * fat + 16 * potassium <= 173, "c29")
m.addConstr(16 * potassium + 17 * calcium <= 383, "c30")
m.addConstr(16 * potassium + 3 * vitamin_c + 17 * calcium <= 361, "c31")
m.addConstr(9 * fat + 16 * potassium + 3 * vitamin_c + 17 * calcium <= 361, "c32")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

