
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
grams_of_fat = m.addVar(lb=0, name="grams_of_fat", vtype=gurobi.GRB.CONTINUOUS)
milligrams_of_potassium = m.addVar(lb=0, name="milligrams_of_potassium", vtype=gurobi.GRB.CONTINUOUS)
milligrams_of_vitamin_C = m.addVar(lb=0, name="milligrams_of_vitamin_C", vtype=gurobi.GRB.CONTINUOUS)
milligrams_of_calcium = m.addVar(lb=0, name="milligrams_of_calcium", vtype=gurobi.GRB.CONTINUOUS)

# Define the objective function
m.setObjective(3 * grams_of_fat + 3 * milligrams_of_potassium + 7 * milligrams_of_vitamin_C + milligrams_of_calcium, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(17 * grams_of_fat + 2 * milligrams_of_calcium >= 55, name="digestive_support_index_1")
m.addConstr(16 * milligrams_of_potassium + 2 * milligrams_of_calcium >= 62, name="digestive_support_index_2")
m.addConstr(19 * grams_of_fat + 18 * milligrams_of_calcium >= 48, name="muscle_growth_index_1")
m.addConstr(19 * milligrams_of_vitamin_C + 18 * milligrams_of_calcium >= 37, name="muscle_growth_index_2")
m.addConstr(19 * grams_of_fat + 16 * milligrams_of_potassium + 18 * milligrams_of_calcium >= 41, name="muscle_growth_index_3")
m.addConstr(19 * grams_of_fat + 16 * milligrams_of_potassium + 19 * milligrams_of_vitamin_C >= 41, name="muscle_growth_index_4")
m.addConstr(9 * grams_of_fat + 3 * milligrams_of_vitamin_C >= 57, name="cardiovascular_support_index_1")
m.addConstr(9 * grams_of_fat + 16 * milligrams_of_potassium >= 57, name="cardiovascular_support_index_2")
m.addConstr(16 * milligrams_of_potassium + 3 * milligrams_of_vitamin_C >= 68, name="cardiovascular_support_index_3")
m.addConstr(3 * milligrams_of_vitamin_C + 17 * milligrams_of_calcium >= 40, name="cardiovascular_support_index_4")
m.addConstr(6 * grams_of_fat + 8 * milligrams_of_vitamin_C - 4 * milligrams_of_calcium >= 0, name="linear_constraint")
m.addConstr(15 * milligrams_of_vitamin_C + 2 * milligrams_of_calcium <= 360, name="digestive_support_index_3")
m.addConstr(17 * grams_of_fat + 16 * milligrams_of_potassium <= 446, name="digestive_support_index_4")
m.addConstr(17 * grams_of_fat + 2 * milligrams_of_calcium <= 335, name="digestive_support_index_5")
m.addConstr(17 * grams_of_fat + 15 * milligrams_of_vitamin_C + 2 * milligrams_of_calcium <= 316, name="digestive_support_index_6")
m.addConstr(17 * grams_of_fat + 16 * milligrams_of_potassium + 15 * milligrams_of_vitamin_C + 2 * milligrams_of_calcium <= 316, name="digestive_support_index_7")
m.addConstr(19 * milligrams_of_vitamin_C + 18 * milligrams_of_calcium <= 140, name="muscle_growth_index_5")
m.addConstr(19 * grams_of_fat + 16 * milligrams_of_potassium <= 118, name="muscle_growth_index_6")
m.addConstr(16 * milligrams_of_potassium + 19 * milligrams_of_vitamin_C <= 86, name="muscle_growth_index_7")
m.addConstr(19 * grams_of_fat + 16 * milligrams_of_potassium + 19 * milligrams_of_vitamin_C + 18 * milligrams_of_calcium <= 86, name="muscle_growth_index_8")
m.addConstr(16 * grams_of_fat + 8 * milligrams_of_vitamin_C <= 405, name="immune_support_index_1")
m.addConstr(7 * milligrams_of_potassium + 6 * milligrams_of_calcium <= 289, name="immune_support_index_2")
m.addConstr(7 * milligrams_of_potassium + 8 * milligrams_of_vitamin_C <= 448, name="immune_support_index_3")
m.addConstr(16 * grams_of_fat + 7 * milligrams_of_potassium <= 427, name="immune_support_index_4")
m.addConstr(16 * grams_of_fat + 6 * milligrams_of_calcium <= 481, name="immune_support_index_5")
m.addConstr(16 * grams_of_fat + 7 * milligrams_of_potassium + 8 * milligrams_of_vitamin_C + 6 * milligrams_of_calcium <= 481, name="immune_support_index_6")
m.addConstr(9 * grams_of_fat + 17 * milligrams_of_calcium <= 283, name="cardiovascular_support_index_5")
m.addConstr(16 * milligrams_of_potassium + 3 * milligrams_of_vitamin_C <= 332, name="cardiovascular_support_index_6")
m.addConstr(9 * grams_of_fat + 16 * milligrams_of_potassium <= 173, name="cardiovascular_support_index_7")
m.addConstr(16 * milligrams_of_potassium + 17 * milligrams_of_calcium <= 383, name="cardiovascular_support_index_8")
m.addConstr(16 * milligrams_of_potassium + 3 * milligrams_of_vitamin_C + 17 * milligrams_of_calcium <= 361, name="cardiovascular_support_index_9")
m.addConstr(9 * grams_of_fat + 16 * milligrams_of_potassium + 3 * milligrams_of_vitamin_C + 17 * milligrams_of_calcium <= 361, name="cardiovascular_support_index_10")

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Grams of fat:", grams_of_fat.varValue)
    print("Milligrams of potassium:", milligrams_of_potassium.varValue)
    print("Milligrams of vitamin C:", milligrams_of_vitamin_C.varValue)
    print("Milligrams of calcium:", milligrams_of_calcium.varValue)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found.")
