
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
peanutbutter_sandwiches = m.addVar(lb=0, name="peanutbutter_sandwiches")
lemons = m.addVar(lb=0, name="lemons")
slices_of_pizza = m.addVar(lb=0, name="slices_of_pizza")

# Set objective function
m.setObjective(3 * peanutbutter_sandwiches * lemons + 4 * slices_of_pizza * slices_of_pizza + 1 * lemons, GRB.MINIMIZE)

# Add constraints
m.addConstr(1.84 * peanutbutter_sandwiches + 12.6 * slices_of_pizza >= 32, "tastiness_constraint1")
m.addConstr(4.98 * lemons + 12.6 * slices_of_pizza >= 20, "tastiness_constraint2")
m.addConstr(1.84 * peanutbutter_sandwiches + 4.98 * lemons >= 18, "tastiness_constraint3")
m.addConstr(1.84 * peanutbutter_sandwiches + 4.98 * lemons + 12.6 * slices_of_pizza >= 18, "tastiness_constraint4")

m.addConstr(3.49 * peanutbutter_sandwiches + 7.75 * slices_of_pizza >= 35, "healthiness_constraint1")
m.addConstr(3.39 * lemons + 7.75 * slices_of_pizza >= 40, "healthiness_constraint2")
m.addConstr(3.49 * peanutbutter_sandwiches + 3.39 * lemons + 7.75 * slices_of_pizza >= 26, "healthiness_constraint3")
m.addConstr(3.49 * peanutbutter_sandwiches + 3.39 * lemons + 7.75 * slices_of_pizza >= 26, "healthiness_constraint4")


m.addConstr(6 * peanutbutter_sandwiches - 10 * slices_of_pizza >= 0, "constraint1")
m.addConstr(9 * lemons - 7 * slices_of_pizza >= 0, "constraint2")

m.addConstr(3.39*3.39 * lemons*lemons + 7.75*7.75 * slices_of_pizza*slices_of_pizza <= 95, "constraint3") # Note: Squared constraint implemented
m.addConstr(3.49 * peanutbutter_sandwiches + 3.39 * lemons <= 63, "constraint4")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('peanutbutter_sandwiches:', peanutbutter_sandwiches.x)
    print('lemons:', lemons.x)
    print('slices_of_pizza:', slices_of_pizza.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
