
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
peanutbutter_sandwiches = m.addVar(lb=-gp.GRB.INFINITY, name="peanutbutter_sandwiches")
lemons = m.addVar(lb=-gp.GRB.INFINITY, name="lemons")
slices_of_pizza = m.addVar(lb=-gp.GRB.INFINITY, name="slices_of_pizza")

# Objective function
m.setObjective(3 * peanutbutter_sandwiches * lemons + 4 * slices_of_pizza**2 + lemons, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(1.84 * peanutbutter_sandwiches + 12.6 * slices_of_pizza >= 32, name="tastiness_pb_pizza")
m.addConstr(4.98 * lemons + 12.6 * slices_of_pizza >= 20, name="tastiness_lemons_pizza")
m.addConstr(1.84 * peanutbutter_sandwiches + 4.98 * lemons >= 18, name="tastiness_pb_lemons")
m.addConstr(1.84 * peanutbutter_sandwiches + 4.98 * lemons + 12.6 * slices_of_pizza >= 18, name="tastiness_all")

m.addConstr(3.49 * peanutbutter_sandwiches + 7.75 * slices_of_pizza >= 35, name="healthiness_pb_pizza")
m.addConstr(3.39 * lemons + 7.75 * slices_of_pizza >= 40, name="healthiness_lemons_pizza")
m.addConstr(3.49 * peanutbutter_sandwiches + 3.39 * lemons + 7.75 * slices_of_pizza >= 26, name="healthiness_all")

m.addConstr(6 * peanutbutter_sandwiches - 10 * slices_of_pizza >= 0, name="pb_pizza_constraint")
m.addConstr(9 * lemons - 7 * slices_of_pizza >= 0, name="lemons_pizza_constraint")

m.addConstr((3.39 * lemons)**2 + (7.75 * slices_of_pizza)**2 <= 95, name="healthiness_squared")
m.addConstr(3.49 * peanutbutter_sandwiches + 3.39 * lemons <= 63, name="pb_lemons_healthiness")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Peanutbutter sandwiches: {peanutbutter_sandwiches.varValue}")
    print(f"Lemons: {lemons.varValue}")
    print(f"Slices of pizza: {slices_of_pizza.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
