
from gurobipy import Model, GRB, quicksum

# Create a new model
m = Model("optimization_problem")

# Create variables
george_hours = m.addVar(vtype=GRB.INTEGER, name="george_hours")
bill_hours = m.addVar(vtype=GRB.CONTINUOUS, name="bill_hours")
laura_hours = m.addVar(vtype=GRB.CONTINUOUS, name="laura_hours")

# Set objective function
m.setObjective(8*george_hours**2 + 8*george_hours*bill_hours + 8*george_hours*laura_hours + 9*bill_hours**2 + 6*bill_hours*laura_hours + laura_hours**2 + 3*george_hours + 4*bill_hours + 5*laura_hours, GRB.MINIMIZE)

# Add constraints
m.addConstr(3*bill_hours**2 + 22*laura_hours**2 >= 64, "c0")
m.addConstr(26*george_hours + 3*bill_hours + 22*laura_hours >= 64, "c1")
m.addConstr(15*bill_hours + 12*laura_hours >= 16, "c2")
m.addConstr(5*george_hours**2 + 12*laura_hours**2 >= 37, "c3")
m.addConstr(5*george_hours + 15*bill_hours + 12*laura_hours >= 37, "c4")
m.addConstr(20*george_hours**2 + 19*laura_hours**2 >= 77, "c5")
m.addConstr(20*george_hours + 24*bill_hours >= 74, "c6")
m.addConstr(20*george_hours + 24*bill_hours + 19*laura_hours >= 74, "c7")
m.addConstr(george_hours + 23*bill_hours >= 29, "c8")
m.addConstr(23*bill_hours + 29*laura_hours >= 61, "c9")
m.addConstr(george_hours**2 + 23*bill_hours**2 + 29*laura_hours**2 >= 72, "c10")
m.addConstr(george_hours + 23*bill_hours + 29*laura_hours >= 72, "c11")
m.addConstr(3*george_hours + 3*laura_hours >= 58, "c12")
m.addConstr(12*bill_hours + 3*laura_hours >= 54, "c13")
m.addConstr(3*george_hours + 12*bill_hours + 3*laura_hours >= 54, "c14")
m.addConstr(10*george_hours**2 - 8*laura_hours**2 >= 0, "c15")
m.addConstr(9*george_hours - 4*bill_hours >= 0, "c16")
m.addConstr(26*george_hours + 3*bill_hours <= 111, "c17")
m.addConstr(5*george_hours + 12*laura_hours <= 115, "c18")
m.addConstr(12*bill_hours + 3*laura_hours <= 111, "c19")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('George Hours:', george_hours.x)
    print('Bill Hours:', bill_hours.x)
    print('Laura Hours:', laura_hours.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
