
from gurobipy import Model, GRB

# Create a new model
model = Model("carbohydrate_optimization")

# Create variables
chicken_thighs = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chicken_thighs")
bagged_salads = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bagged_salads")
hamburgers = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hamburgers")
granola_bars = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="granola_bars")
corn_cobs = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="corn_cobs")

# Set objective function
model.setObjective(8.94 * chicken_thighs * bagged_salads + 3.49 * chicken_thighs * granola_bars + 6.96 * bagged_salads * bagged_salads + 1.22 * bagged_salads * corn_cobs + 5.04 * hamburgers * granola_bars + 9.86 * hamburgers + 1.62 * corn_cobs, GRB.MINIMIZE)

# Add constraints
model.addConstr(hamburgers*hamburgers + granola_bars*granola_bars >= 31, "c1")
model.addConstr(5 * chicken_thighs + 5 * bagged_salads >= 24, "c2")
model.addConstr(5 * chicken_thighs + 2 * granola_bars >= 24, "c3")
model.addConstr(5 * bagged_salads + 2 * corn_cobs >= 23, "c4")
model.addConstr(hamburgers + 2 * corn_cobs >= 17, "c5")
model.addConstr(5 * bagged_salads + 2 * granola_bars >= 39, "c6")
model.addConstr(5 * chicken_thighs + hamburgers + 2 * corn_cobs >= 21, "c7")
model.addConstr(5*chicken_thighs*chicken_thighs + 5*bagged_salads*bagged_salads + 2*corn_cobs*corn_cobs >= 21, "c8")
model.addConstr(hamburgers + 2 * granola_bars + 2 * corn_cobs >= 21, "c9")
model.addConstr(5 * chicken_thighs + hamburgers + 2 * corn_cobs >= 29, "c10")
model.addConstr(5 * chicken_thighs + 5 * bagged_salads + 2 * corn_cobs >= 29, "c11")
model.addConstr(hamburgers + 2 * granola_bars + 2 * corn_cobs >= 29, "c12")
model.addConstr(5*chicken_thighs*chicken_thighs + hamburgers*hamburgers + 2*corn_cobs*corn_cobs >= 27, "c13")
model.addConstr(5 * chicken_thighs + 5 * bagged_salads + 2 * corn_cobs >= 27, "c14")
model.addConstr(hamburgers*hamburgers + 2*granola_bars*granola_bars + 2*corn_cobs*corn_cobs >= 27, "c15")
model.addConstr(5 * chicken_thighs + 5 * bagged_salads + hamburgers + 2 * granola_bars + 2 * corn_cobs >= 27, "c16")
model.addConstr(-6 * bagged_salads * bagged_salads + 5 * hamburgers * hamburgers >= 0, "c17")
model.addConstr(-5 * hamburgers * hamburgers + 8 * corn_cobs * corn_cobs >= 0, "c18")
model.addConstr(5 * bagged_salads * bagged_salads + hamburgers * hamburgers <= 204, "c19")
model.addConstr(hamburgers + 2 * granola_bars <= 156, "c20")
model.addConstr(5 * chicken_thighs + 2 * corn_cobs <= 117, "c21")
model.addConstr(5 * bagged_salads + 2 * corn_cobs <= 81, "c22")
model.addConstr(5 * chicken_thighs + 2 * granola_bars <= 58, "c23")
model.addConstr(5 * chicken_thighs + hamburgers <= 54, "c24")
model.addConstr(5 * chicken_thighs + 5 * bagged_salads <= 86, "c25")
model.addConstr(5 * chicken_thighs + 5 * bagged_salads + 2 * corn_cobs <= 119, "c26")
model.addConstr(hamburgers + 2 * granola_bars + 2 * corn_cobs <= 93, "c27")
model.addConstr(5*bagged_salads*bagged_salads + hamburgers*hamburgers + 2*corn_cobs*corn_cobs <= 103, "c28")
model.addConstr(5*chicken_thighs*chicken_thighs + 5*bagged_salads*bagged_salads + hamburgers*hamburgers <= 194, "c29")
model.addConstr(5 * chicken_thighs + 5 * bagged_salads + hamburgers + 2 * granola_bars + 2 * corn_cobs <= 214, "carbohydrate_limit")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", model.status)

