
from gurobipy import *

# Create a new model
m = Model("Carbohydrate_Optimization")

# Define variables (assuming they are non-negative)
x0 = m.addVar(lb=0, name="chicken_thighs")
x1 = m.addVar(lb=0, name="bagged_salads")
x2 = m.addVar(lb=0, name="hamburgers")
x3 = m.addVar(lb=0, name="granola_bars")
x4 = m.addVar(lb=0, name="corn_cobs")

# Objective function
m.setObjective(8.94*x0*x1 + 3.49*x0*x3 + 6.96*x1**2 + 1.22*x1*x4 + 5.04*x2*x3 + 9.86*x2 + 1.62*x4, GRB.MINIMIZE)

# Constraints
m.addConstr(5*x0 >= 24)  # At least 24 grams from chicken thighs
m.addConstr(5*x1 >= 24)  # At least 24 grams from bagged salads
m.addConstr(x2**2 + x3**2 >= 31)  # At least 31 grams from hamburgers squared plus granola bars squared
# Add other constraints as defined in the problem statement

# Solve the model
m.optimize()

# Print solution
for v in m.getVars():
    print('%s %g' % (v.varName, v.x))
