
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="chicken_thighs", lb=0)
x1 = m.addVar(name="bagged_salads", lb=0)
x2 = m.addVar(name="hamburgers", lb=0)
x3 = m.addVar(name="granola_bars", lb=0)
x4 = m.addVar(name="corn_cobs", lb=0)

# Objective function
m.setObjective(8.94*x0*x1 + 3.49*x0*x3 + 6.96*x1**2 + 1.22*x1*x4 + 5.04*x2*x3 + 9.86*x2 + 1.62*x4, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(5*x0 + 5*x1 + x2 + 2*x3 + 2*x4 <= 214)
m.addConstr(x2**2 + x3**2 >= 31)
m.addConstr(5*x0 + 5*x1 >= 24)
m.addConstr(5*x0 + 2*x3 >= 24)
m.addConstr(5*x1 + 2*x4 >= 23)
m.addConstr(x2 + 2*x4 >= 17)
m.addConstr(5*x1 + 2*x3 >= 39)
m.addConstr(5*x0 + x2 + 2*x4 >= 21)
m.addConstr(5*x0**2 + 5*x1**2 + 2*x4**2 >= 21)
m.addConstr(x2 + 2*x3 + 2*x4 >= 21)
m.addConstr(5*x0 + x2 + 2*x4 >= 29)
m.addConstr(5*x0 + 5*x1 + 2*x4 >= 29)
m.addConstr(x2 + 2*x3 + 2*x4 >= 29)
m.addConstr(5*x0**2 + x2**2 + 2*x4**2 >= 27)
m.addConstr(5*x0 + 5*x1 + 2*x4 >= 27)
m.addConstr(x2**2 + 2*x3**2 + 2*x4**2 >= 27)
m.addConstr(5*x0 + 5*x1 + x2 + 2*x3 + 2*x4 >= 27)
m.addConstr(-6*x1**2 + 5*x2**2 >= 0)
m.addConstr(-5*x2**2 + 8*x4**2 >= 0)
m.addConstr(5*x1**2 + x2**2 <= 204)
m.addConstr(x2 + 2*x3 <= 156)
m.addConstr(5*x0 + 2*x4 <= 117)
m.addConstr(5*x1 + 2*x4 <= 81)
m.addConstr(5*x0 + 2*x3 <= 58)
m.addConstr(5*x0 + x2 <= 54)
m.addConstr(5*x0 + 5*x1 <= 86)
m.addConstr(5*x0 + 5*x1 + 2*x4 <= 119)
m.addConstr(x2 + 2*x3 + 2*x4 <= 93)
m.addConstr(5*x1**2 + x2**2 + 2*x4**2 <= 103)
m.addConstr(5*x0**2 + 5*x1**2 + x2**2 <= 194)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Chicken thighs: ", x0.x)
    print("Bagged salads: ", x1.x)
    print("Hamburgers: ", x2.x)
    print("Granola bars: ", x3.x)
    print("Corn cobs: ", x4.x)
else:
    print("No solution found")
