
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="grams of carbohydrates")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams of vitamin B5")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams of vitamin B4")

# Set objective function
m.setObjective(5.42*x0**2 + 3.59*x0*x1 + 4.15*x0*x2 + 5.43*x1*x2 + 7.08*x2**2 + 6.25*x0 + 7.4*x1 + 6.3*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(20*x0 + 8*x2 >= 61, "c0")
m.addConstr(16*x1 + 8*x2 >= 87, "c1")
m.addConstr(20*x0**2 + 16*x1**2 >= 91, "c2")
m.addConstr(20*x0 + 16*x1 + 8*x2 >= 91, "c3")
m.addConstr(13*x1**2 + 5*x2**2 >= 26, "c4")
m.addConstr(20*x0 + 13*x1 + 5*x2 >= 26, "c5")
m.addConstr(11*x1 + 10*x2 >= 18, "c6")
m.addConstr(1*x0 + 11*x1 + 10*x2 >= 18, "c7")
m.addConstr(-6*x0 + 8*x1 >= 0, "c8")
m.addConstr(20*x0 + 5*x2 <= 95, "c9")
m.addConstr(20*x0 + 13*x1 <= 98, "c10")
m.addConstr(13*x1 + 5*x2 <= 91, "c11")


# Resource Constraints (from the provided dictionary)
m.addConstr(20*x0 + 16*x1 + 8*x2 <= 281, "r0") # Muscle growth
m.addConstr(20*x0 + 13*x1 + 5*x2 <= 98, "r1")  # Kidney support
m.addConstr(1*x0 + 11*x1 + 10*x2 <= 92, "r2")  # Immune support


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

