
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="grams_of_carbohydrates", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x1 = m.addVar(name="milligrams_of_vitamin_B5", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x2 = m.addVar(name="milligrams_of_vitamin_B4", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)

# Define the objective function
m.setObjective(5.42*x0**2 + 3.59*x0*x1 + 4.15*x0*x2 + 5.43*x1*x2 + 7.08*x2**2 + 6.25*x0 + 7.4*x1 + 6.3*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(20*x0 <= 281, name="muscle_growth_index_carbohydrates")
m.addConstr(20*x0 <= 98, name="kidney_support_index_carbohydrates")
m.addConstr(x0 <= 92, name="immune_support_index_carbohydrates")
m.addConstr(16*x1 <= 281, name="muscle_growth_index_vitamin_B5")
m.addConstr(13*x1 <= 98, name="kidney_support_index_vitamin_B5")
m.addConstr(11*x1 <= 92, name="immune_support_index_vitamin_B5")
m.addConstr(8*x2 <= 281, name="muscle_growth_index_vitamin_B4")
m.addConstr(5*x2 <= 98, name="kidney_support_index_vitamin_B4")
m.addConstr(10*x2 <= 92, name="immune_support_index_vitamin_B4")
m.addConstr(20*x0 + 8*x2 >= 61, name="min_muscle_growth_index")
m.addConstr(16*x1 + 8*x2 >= 87, name="min_muscle_growth_index_B5_B4")
m.addConstr(400*x0**2 + 256*x1**2 >= 91, name="min_muscle_growth_index_squared")
m.addConstr(20*x0 + 16*x1 + 8*x2 >= 91, name="min_muscle_growth_index_total")
m.addConstr(169*x1**2 + 25*x2**2 >= 26, name="min_kidney_support_index_squared")
m.addConstr(20*x0 + 13*x1 + 5*x2 >= 26, name="min_kidney_support_index_total")
m.addConstr(11*x1 + 10*x2 >= 18, name="min_immune_support_index_B5_B4")
m.addConstr(x0 + 11*x1 + 10*x2 >= 18, name="min_immune_support_index_total")
m.addConstr(-6*x0 + 8*x1 >= 0, name="balance_constraint")
m.addConstr(20*x0 + 5*x2 <= 95, name="max_kidney_support_index_carbohydrates_B4")
m.addConstr(20*x0 + 13*x1 <= 98, name="max_kidney_support_index_carbohydrates_B5")
m.addConstr(13*x1 + 5*x2 <= 91, name="max_kidney_support_index_B5_B4")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Grams of carbohydrates: ", x0.varValue)
    print("Milligrams of vitamin B5: ", x1.varValue)
    print("Milligrams of vitamin B4: ", x2.varValue)
else:
    print("The model is infeasible")
