
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("food_optimization")

# Create variables
chicken_thighs = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chicken_thighs")
kale_salads = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="kale_salads")
hot_dogs = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hot_dogs")
bagged_salads = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bagged_salads")

# Set objective function
m.setObjective(8 * chicken_thighs + 7 * kale_salads + 2 * hot_dogs + 3 * bagged_salads, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * chicken_thighs + 6 * hot_dogs >= 21, "fat_constraint1")
m.addConstr(3 * chicken_thighs + 1 * kale_salads + 8 * bagged_salads >= 13, "fat_constraint2")
m.addConstr(3 * chicken_thighs + 6 * hot_dogs + 8 * bagged_salads >= 13, "fat_constraint3")
m.addConstr(3 * chicken_thighs + 1 * kale_salads + 6 * hot_dogs >= 13, "fat_constraint4")
m.addConstr(3 * chicken_thighs + 1 * kale_salads + 8 * bagged_salads >= 21, "fat_constraint5")
m.addConstr(3 * chicken_thighs + 6 * hot_dogs + 8 * bagged_salads >= 21, "fat_constraint6")
m.addConstr(3 * chicken_thighs + 1 * kale_salads + 6 * hot_dogs >= 21, "fat_constraint7")
m.addConstr(3 * chicken_thighs + 1 * kale_salads + 8 * bagged_salads >= 21, "fat_constraint8")
m.addConstr(3 * chicken_thighs + 6 * hot_dogs + 8 * bagged_salads >= 21, "fat_constraint9")
m.addConstr(3 * chicken_thighs + 1 * kale_salads + 6 * hot_dogs >= 21, "fat_constraint10")

m.addConstr(3 * hot_dogs + 2 * bagged_salads >= 21, "protein_constraint1")
m.addConstr(8 * chicken_thighs + 2 * kale_salads + 2 * bagged_salads >= 20, "protein_constraint2")
m.addConstr(8 * chicken_thighs + 3 * hot_dogs + 2 * bagged_salads >= 20, "protein_constraint3")
m.addConstr(2 * kale_salads + 3 * hot_dogs + 2 * bagged_salads >= 20, "protein_constraint4")
m.addConstr(8 * chicken_thighs + 2 * kale_salads + 2 * bagged_salads >= 13, "protein_constraint5")
m.addConstr(8 * chicken_thighs + 3 * hot_dogs + 2 * bagged_salads >= 13, "protein_constraint6")
m.addConstr(2 * kale_salads + 3 * hot_dogs + 2 * bagged_salads >= 13, "protein_constraint7")
m.addConstr(8 * chicken_thighs + 2 * kale_salads + 2 * bagged_salads >= 20, "protein_constraint8")
m.addConstr(8 * chicken_thighs + 3 * hot_dogs + 2 * bagged_salads >= 20, "protein_constraint9")
m.addConstr(2 * kale_salads + 3 * hot_dogs + 2 * bagged_salads >= 20, "protein_constraint10")


m.addConstr(3 * kale_salads + 6 * bagged_salads >= 4, "cost_constraint1")
m.addConstr(1 * kale_salads + 8 * bagged_salads <= 79, "fat_constraint11")
m.addConstr(3 * chicken_thighs + 1 * kale_salads <= 36, "fat_constraint12")
m.addConstr(3 * chicken_thighs + 8 * bagged_salads <= 22, "fat_constraint13")
m.addConstr(6 * hot_dogs + 8 * bagged_salads <= 54, "fat_constraint14")
m.addConstr(3 * chicken_thighs + 1 * kale_salads + 8 * bagged_salads <= 74, "fat_constraint15")
m.addConstr(3 * chicken_thighs + 6 * hot_dogs + 8 * bagged_salads <= 76, "fat_constraint16")
m.addConstr(3 * chicken_thighs + 1 * kale_salads + 6 * hot_dogs + 8 * bagged_salads <= 76, "fat_constraint17")

m.addConstr(3 * hot_dogs + 2 * bagged_salads <= 24, "protein_constraint11")
m.addConstr(2 * kale_salads + 3 * hot_dogs <= 84, "protein_constraint12")
m.addConstr(8 * chicken_thighs + 3 * hot_dogs <= 89, "protein_constraint13")
m.addConstr(8 * chicken_thighs + 2 * kale_salads <= 52, "protein_constraint14")
m.addConstr(8 * chicken_thighs + 2 * bagged_salads <= 89, "protein_constraint15")
m.addConstr(8 * chicken_thighs + 2 * kale_salads + 3 * hot_dogs + 2 * bagged_salads <= 89, "protein_constraint16")

m.addConstr(3 * hot_dogs + 6 * bagged_salads <= 40, "cost_constraint2")
m.addConstr(3 * kale_salads + 3 * hot_dogs <= 17, "cost_constraint3")
m.addConstr(5 * chicken_thighs + 3 * kale_salads <= 26, "cost_constraint4")
m.addConstr(5 * chicken_thighs + 3 * hot_dogs + 6 * bagged_salads <= 25, "cost_constraint5")
m.addConstr(5 * chicken_thighs + 3 * kale_salads + 3 * hot_dogs + 6 * bagged_salads <= 25, "cost_constraint6")

m.addConstr(5 * chicken_thighs + 5 * hot_dogs <= 45, "health_constraint1")
m.addConstr(5 * hot_dogs + 2 * bagged_salads <= 25, "health_constraint2")
m.addConstr(8 * kale_salads + 2 * bagged_salads <= 56, "health_constraint3")
m.addConstr(5 * chicken_thighs + 8 * kale_salads + 5 * hot_dogs + 2 * bagged_salads <= 56, "health_constraint4")


# Resource Constraints (given in the problem description)
m.addConstr(3 * chicken_thighs + 1 * kale_salads + 6 * hot_dogs + 8 * bagged_salads <= 84, "total_fat")
m.addConstr(8 * chicken_thighs + 2 * kale_salads + 3 * hot_dogs + 2 * bagged_salads <= 94, "total_protein")
m.addConstr(5 * chicken_thighs + 3 * kale_salads + 3 * hot_dogs + 6 * bagged_salads <= 49, "total_cost")
m.addConstr(5 * chicken_thighs + 8 * kale_salads + 5 * hot_dogs + 2 * bagged_salads <= 85, "total_health")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)
