
from gurobipy import *

# Create a model
m = Model("Vitamin_Optimization")

# Define the variables
x0 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_B12")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B3")

# Objective function: Maximize 5.84*x0 + 1.76*x1
m.setObjective(5.84*x0 + 1.76*x1, GRB.MAXIMIZE)

# Constraints
# Digestive support index constraints
m.addConstr(3*x0 + 7*x1 >= 13, name="digestive_support_index_min")
m.addConstr(3*x0 + 7*x1 <= 55, name="digestive_support_index_max")

# Cardiovascular support index constraints
m.addConstr(4*x0 + 4*x1 >= 3, name="cardiovascular_support_index_min")
m.addConstr(4*x0 + 4*x1 <= 14, name="cardiovascular_support_index_max")

# Cognitive performance index constraints
m.addConstr(5*x0 + 9*x1 >= 13, name="cognitive_performance_index_min")
m.addConstr(5*x0 + 9*x1 <= 15, name="cognitive_performance_index_max")

# Linear constraint
m.addConstr(5*x0 - 9*x1 >= 0, name="linear_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B12: {x0.x}")
    print(f"Milligrams of Vitamin B3: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
