
import gurobi

def optimize_vitamins():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="milligrams_of_vitamin_B12", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="milligrams_of_vitamin_B3")

    # Objective function: Maximize 5.84 * x0 + 1.76 * x1
    model.setObjective(5.84 * x0 + 1.76 * x1, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3 * x0 + 7 * x1 >= 13, name="digestive_support_index")
    model.addConstr(4 * x0 + 4 * x1 >= 3, name="cardiovascular_support_index")
    model.addConstr(5 * x0 + 9 * x1 >= 13, name="cognitive_performance_index")
    model.addConstr(5 * x0 - 9 * x1 >= 0, name="linear_constraint")
    model.addConstr(3 * x0 + 7 * x1 <= 55, name="digestive_support_index_upper_bound")
    model.addConstr(4 * x0 + 4 * x1 <= 14, name="cardiovascular_support_index_upper_bound")
    model.addConstr(5 * x0 + 9 * x1 <= 15, name="cognitive_performance_index_upper_bound")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B12: {x0.varValue}")
        print(f"Milligrams of vitamin B3: {x1.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("Optimization failed.")

optimize_vitamins()
