
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define the variables
B = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Bill")
G = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_George")
J = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Jean")

# Objective function
m.setObjective(3.77*B + 5.17*G + 8.77*J, GRB.MAXIMIZE)

# Constraints
m.addConstr(3*B + 10*G + 6*J >= 11, name="total_productivity_minimum")
m.addConstr(13*G + 5*J >= 10, name="george_jean_organization_score")
m.addConstr(8*B + 5*J >= 18, name="bill_jean_organization_score")
m.addConstr(8*B + 13*G >= 14, name="bill_george_organization_score")
m.addConstr(3*B + 10*G <= 14, name="bill_george_productivity_limit")
m.addConstr(3*B + 6*J <= 30, name="bill_jean_productivity_limit")
m.addConstr(3*B + 10*G + 6*J <= 30, name="total_productivity_limit")
m.addConstr(13*G + 5*J <= 54, name="george_jean_organization_score_max")
m.addConstr(8*B + 13*G <= 20, name="bill_george_organization_score_max")
m.addConstr(8*B + 5*J <= 29, name="bill_jean_organization_score_max")
m.addConstr(8*B + 13*G + 5*J <= 38, name="total_organization_score_max")

# Solve the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Bill: {B.x}")
    print(f"Hours worked by George: {G.x}")
    print(f"Hours worked by Jean: {J.x}")
else:
    print("No optimal solution found.")
