
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    B = model.addVar(name="B", lowBound=0, integrality=1)  # Bill's hours
    G = model.addVar(name="G", lowBound=0, integrality=1)  # George's hours
    J = model.addVar(name="J", lowBound=0, integrality=1)  # Jean's hours

    # Define the objective function
    model.setObjective(3.77 * B + 5.17 * G + 8.77 * J, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3 * B + 10 * G + 6 * J >= 11)  # Productivity rating constraint
    model.addConstr(13 * G + 5 * J >= 10)  # Organization score from George and Jean
    model.addConstr(8 * B + 5 * J >= 18)  # Organization score from Bill and Jean
    model.addConstr(8 * B + 13 * G >= 14)  # Organization score from Bill and George
    model.addConstr(3 * B + 10 * G <= 14)  # Productivity rating from Bill and George
    model.addConstr(3 * B + 6 * J <= 30)  # Productivity rating from Bill and Jean
    model.addConstr(3 * B + 10 * G + 6 * J <= 30)  # Productivity rating from all
    model.addConstr(13 * G + 5 * J <= 54)  # Organization score from George and Jean
    model.addConstr(8 * B + 13 * G <= 20)  # Organization score from Bill and George
    model.addConstr(8 * B + 5 * J <= 29)  # Organization score from Bill and Jean
    model.addConstr(8 * B + 13 * G + 5 * J <= 38)  # Organization score from all

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Bill's hours: {B.varValue}")
        print(f"George's hours: {G.varValue}")
        print(f"Jean's hours: {J.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
