
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
x0 = m.addVar(lb=0, name="rotisserie_chickens")  # Rotisserie chickens
x1 = m.addVar(lb=0, name="ham_sandwiches")  # Ham sandwiches
x2 = m.addVar(lb=0, name="potatoes")  # Potatoes

# Set objective function
m.setObjective(2.4 * x0 + 2.19 * x1 + 6.37 * x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(15 * x0 + 6 * x1 + 15 * x2 >= 28, "calcium_min")
m.addConstr(17 * x1 + 21 * x2 >= 25, "fat_min_1")
m.addConstr(20 * x0 + 21 * x2 >= 38, "fat_min_2")
m.addConstr(20 * x0 + 17 * x1 + 21 * x2 >= 35, "fat_min_3")
m.addConstr(5 * x0 + 14 * x1 >= 13, "carbs_min_1")
m.addConstr(14 * x1 + 8 * x2 >= 14, "carbs_min_2")
m.addConstr(5 * x0 + 8 * x2 >= 14, "carbs_min_3")

m.addConstr(15 * x0 + 6 * x1 <= 40, "calcium_max_1")
m.addConstr(15 * x0 + 6 * x1 + 15 * x2 <= 40, "calcium_max_2") # corrected constraint
m.addConstr(17 * x1 + 21 * x2 <= 77, "fat_max_1")
m.addConstr(20 * x0 + 17 * x1 <= 105, "fat_max_2")
m.addConstr(20 * x0 + 21 * x2 <= 114, "fat_max_3")
m.addConstr(20 * x0 + 17 * x1 + 21 * x2 <= 114, "fat_max_4") # corrected constraint
m.addConstr(5 * x0 + 14 * x1 <= 63, "carbs_max_1")
m.addConstr(14 * x1 + 8 * x2 <= 60, "carbs_max_2")
m.addConstr(5 * x0 + 14 * x1 + 8 * x2 <= 60, "carbs_max_3")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Rotisserie Chickens:", x0.x)
    print("Ham Sandwiches:", x1.x)
    print("Potatoes:", x2.x)
    print("Objective Value:", m.objVal)
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print("Optimization terminated with status:", m.status)

