
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="rotisserie_chickens", lb=0)  # Non-negative
    x1 = model.addVar(name="ham_sandwiches", lb=0)    # Non-negative
    x2 = model.addVar(name="potatoes", lb=0)        # Non-negative

    # Objective function
    model.setObjective(2.4 * x0 + 2.19 * x1 + 6.37 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(15 * x0 + 6 * x1 + 15 * x2 >= 28)  # Calcium total minimum
    model.addConstr(15 * x0 + 6 * x1 + 15 * x2 <= 122) # Calcium total upper bound

    model.addConstr(17 * x1 + 21 * x2 >= 25)  # Fat from ham sandwiches and potatoes
    model.addConstr(20 * x0 + 21 * x2 >= 38)  # Fat from rotisserie chickens and potatoes
    model.addConstr(20 * x0 + 17 * x1 + 21 * x2 >= 35)  # Total fat minimum
    model.addConstr(20 * x0 + 17 * x1 + 21 * x2 <= 143) # Total fat upper bound

    model.addConstr(5 * x0 + 14 * x1 >= 13)  # Carbohydrates from rotisserie chickens and ham sandwiches
    model.addConstr(14 * x1 + 8 * x2 >= 14)  # Carbohydrates from ham sandwiches and potatoes
    model.addConstr(5 * x0 + 8 * x2 >= 14)   # Carbohydrates from rotisserie chickens and potatoes
    model.addConstr(5 * x0 + 14 * x1 <= 63)  # Carbohydrates from rotisserie chickens and ham sandwiches upper bound
    model.addConstr(14 * x1 + 8 * x2 <= 60)  # Carbohydrates from ham sandwiches and potatoes upper bound
    model.addConstr(5 * x0 + 14 * x1 + 8 * x2 <= 60)  # Total carbohydrates upper bound

    model.addConstr(15 * x0 + 6 * x1 <= 40)  # Calcium from rotisserie chickens and ham sandwiches upper bound

    model.addConstr(17 * x1 + 21 * x2 <= 77)  # Fat from ham sandwiches and potatoes upper bound
    model.addConstr(20 * x0 + 17 * x1 <= 105) # Fat from rotisserie chickens and ham sandwiches upper bound
    model.addConstr(20 * x0 + 21 * x2 <= 114) # Fat from rotisserie chickens and potatoes upper bound

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Rotisserie chickens: ", x0.varValue)
        print("Ham sandwiches: ", x1.varValue)
        print("Potatoes: ", x2.varValue)
    else:
        print("No optimal solution found")

optimize_problem()
