
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
apple_pies = m.addVar(lb=0, name="apple_pies")
pasta = m.addVar(lb=0, name="bowls_of_pasta")
cereal = m.addVar(lb=0, name="bowls_of_cereal")
sandwiches = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="ham_sandwiches")

# Set objective function
m.setObjective(5.64 * apple_pies + 5.52 * pasta + 2.47 * cereal + 8.43 * sandwiches, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(28 * apple_pies + 24 * cereal >= 116, "tastiness_constraint1")
m.addConstr(24 * cereal + 14 * sandwiches <= 387, "tastiness_constraint2")
m.addConstr(28 * apple_pies + 24 * cereal <= 192, "tastiness_constraint3")
m.addConstr(28 * apple_pies + 24 * pasta <= 179, "tastiness_constraint4")
m.addConstr(24 * pasta + 24 * cereal <= 480, "tastiness_constraint5")
m.addConstr(28 * apple_pies + 24 * pasta + 24 * cereal + 14 * sandwiches <= 480, "tastiness_constraint6")

m.addConstr(23 * pasta + 4 * cereal <= 68, "cost_constraint1")
m.addConstr(27 * apple_pies + 23 * pasta <= 132, "cost_constraint2")
m.addConstr(27 * apple_pies + 2 * sandwiches <= 133, "cost_constraint3")
m.addConstr(23 * pasta + 2 * sandwiches <= 80, "cost_constraint4")
m.addConstr(23 * pasta + 4 * cereal + 2 * sandwiches <= 139, "cost_constraint5")
m.addConstr(27 * apple_pies + 23 * pasta + 4 * cereal + 2 * sandwiches <= 139, "cost_constraint6")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

