
import gurobi as grb

# Create a new model
m = grb.Model()

# Define variables
x0 = m.addVar(name="apple_pies", lb=0)  # No lower bound specified, assuming 0
x1 = m.addVar(name="bowls_of_pasta", lb=0)
x2 = m.addVar(name="bowls_of_cereal", lb=0)
x3 = m.addVar(name="ham_sandwiches", lb=0, vtype=grb.GRB.INTEGER)

# Objective function
m.setObjective(5.64 * x0 + 5.52 * x1 + 2.47 * x2 + 8.43 * x3, grb.GRB.MAXIMIZE)

# Constraints
m.addConstr(28 * x0 + 24 * x2 >= 116, name="tastiness_apple_pies_cereal_min")
m.addConstr(24 * x2 + 14 * x3 <= 387, name="tastiness_cereal_ham_sandwiches_max")
m.addConstr(28 * x0 + 24 * x2 <= 192, name="tastiness_apple_pies_cereal_max")
m.addConstr(28 * x0 + 24 * x1 <= 179, name="tastiness_apple_pies_pasta_max")
m.addConstr(24 * x1 + 24 * x2 <= 480, name="tastiness_pasta_cereal_max")
m.addConstr(28 * x0 + 24 * x1 + 24 * x2 + 14 * x3 <= 480, name="tastiness_total_max")
m.addConstr(23 * x1 + 4 * x2 <= 68, name="cost_pasta_cereal_max")
m.addConstr(27 * x0 + 23 * x1 <= 132, name="cost_apple_pies_pasta_max")
m.addConstr(27 * x0 + 2 * x3 <= 133, name="cost_apple_pies_ham_sandwiches_max")
m.addConstr(23 * x1 + 2 * x3 <= 80, name="cost_pasta_ham_sandwiches_max")
m.addConstr(23 * x1 + 4 * x2 + 2 * x3 <= 139, name="cost_pasta_cereal_ham_sandwiches_max")
m.addConstr(27 * x0 + 23 * x1 + 4 * x2 + 2 * x3 <= 139, name="cost_total_max")

# Optimize
m.optimize()

# Print solution
if m.status == grb.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Apple pies: ", x0.varValue)
    print("Bowls of pasta: ", x1.varValue)
    print("Bowls of cereal: ", x2.varValue)
    print("Ham sandwiches: ", x3.varValue)
else:
    print("No optimal solution found")
