
import gurobipy as gp

# Create a new model
m = gp.Model("resource_optimization")

# Create variables
network_admins = m.addVar(vtype=gp.GRB.INTEGER, name="network_administrators")
security_engineers = m.addVar(vtype=gp.GRB.INTEGER, name="security_engineers")
patches_per_day = m.addVar(vtype=gp.GRB.INTEGER, name="patches_per_day")
intrusion_analysts = m.addVar(vtype=gp.GRB.INTEGER, name="intrusion_analysts")
system_admins = m.addVar(vtype=gp.GRB.INTEGER, name="system_administrators")
deployed_decoys = m.addVar(vtype=gp.GRB.INTEGER, name="deployed_decoys")

# Set objective function
m.setObjective(5.04 * network_admins + 3.05 * security_engineers + 8.67 * patches_per_day + 7.16 * intrusion_analysts + 9.53 * system_admins + 6.62 * deployed_decoys, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4 * network_admins + 2 * security_engineers + 19 * patches_per_day + 10 * intrusion_analysts + 15 * system_admins + 14 * deployed_decoys <= 523, "power_consumption")
m.addConstr(13 * network_admins + 14 * security_engineers + 2 * patches_per_day + 4 * intrusion_analysts + 8 * system_admins + 17 * deployed_decoys <= 505, "dollar_cost")

m.addConstr(4 * network_admins + 19 * patches_per_day >= 80, "power_constraint1")
m.addConstr(2 * security_engineers + 19 * patches_per_day >= 68, "power_constraint2")
m.addConstr(2 * security_engineers + 14 * deployed_decoys >= 29, "power_constraint3")
m.addConstr(19 * patches_per_day + 10 * intrusion_analysts >= 56, "power_constraint4")
m.addConstr(4 * network_admins + 2 * security_engineers + 19 * patches_per_day + 10 * intrusion_analysts + 15 * system_admins + 14 * deployed_decoys >= 56, "power_constraint5")


m.addConstr(4 * intrusion_analysts + 8 * system_admins >= 61, "cost_constraint1")
m.addConstr(2 * patches_per_day + 4 * intrusion_analysts >= 52, "cost_constraint2")
m.addConstr(13 * network_admins + 4 * intrusion_analysts >= 55, "cost_constraint3")
m.addConstr(2 * patches_per_day + 8 * system_admins >= 57, "cost_constraint4")
m.addConstr(2 * patches_per_day + 17 * deployed_decoys >= 39, "cost_constraint5")
m.addConstr(8 * system_admins + 17 * deployed_decoys >= 42, "cost_constraint6")
m.addConstr(13 * network_admins + 14 * security_engineers + 4 * intrusion_analysts >= 49, "cost_constraint7")
m.addConstr(14 * security_engineers + 8 * system_admins + 17 * deployed_decoys >= 49, "cost_constraint8")
m.addConstr(2 * patches_per_day + 4 * intrusion_analysts + 8 * system_admins >= 49, "cost_constraint9")
m.addConstr(14 * security_engineers + 2 * patches_per_day + 4 * intrusion_analysts >= 49, "cost_constraint10")
m.addConstr(2 * patches_per_day + 4 * intrusion_analysts + 17 * deployed_decoys >= 49, "cost_constraint11")
m.addConstr(13 * network_admins + 8 * system_admins + 17 * deployed_decoys >= 49, "cost_constraint12")
m.addConstr(13 * network_admins + 14 * security_engineers + 4 * intrusion_analysts >= 61, "cost_constraint13")
m.addConstr(14 * security_engineers + 8 * system_admins + 17 * deployed_decoys >= 61, "cost_constraint14")
m.addConstr(2 * patches_per_day + 4 * intrusion_analysts + 8 * system_admins >= 61, "cost_constraint15")
m.addConstr(14 * security_engineers + 2 * patches_per_day + 4 * intrusion_analysts >= 61, "cost_constraint16")
m.addConstr(2 * patches_per_day + 4 * intrusion_analysts + 17 * deployed_decoys >= 61, "cost_constraint17")
m.addConstr(13 * network_admins + 8 * system_admins + 17 * deployed_decoys >= 61, "cost_constraint18")


# ... (Rest of the constraints -  Follow the same pattern as above)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('\nCost: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization was infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
