
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
network_administrators = m.addVar(name="network_administrators", vtype=gurobi.GRB.INTEGER)
security_engineers = m.addVar(name="security_engineers", vtype=gurobi.GRB.INTEGER)
patches_per_day = m.addVar(name="patches_per_day", vtype=gurobi.GRB.INTEGER)
intrusion_analysts = m.addVar(name="intrusion_analysts", vtype=gurobi.GRB.INTEGER)
system_administrators = m.addVar(name="system_administrators", vtype=gurobi.GRB.INTEGER)
deployed_decoys = m.addVar(name="deployed_decoys", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(5.04 * network_administrators + 3.05 * security_engineers + 8.67 * patches_per_day +
               7.16 * intrusion_analysts + 9.53 * system_administrators + 6.62 * deployed_decoys,
               gurobi.GRB.MINIMIZE)

# Constraints
# Power consumption constraints
m.addConstr(4 * network_administrators + 19 * patches_per_day >= 80, name="power_consumption_1")
m.addConstr(2 * security_engineers + 19 * patches_per_day >= 68, name="power_consumption_2")
m.addConstr(2 * security_engineers + 14 * deployed_decoys >= 29, name="power_consumption_3")
m.addConstr(19 * patches_per_day + 10 * intrusion_analysts >= 56, name="power_consumption_4")
m.addConstr(4 * network_administrators + 2 * security_engineers + 19 * patches_per_day + 10 * intrusion_analysts +
             15 * system_administrators + 14 * deployed_decoys >= 56, name="power_consumption_5")

# Dollar cost constraints
m.addConstr(13 * intrusion_analysts + 8 * system_administrators >= 61, name="dollar_cost_1")
m.addConstr(2 * patches_per_day + 4 * intrusion_analysts >= 52, name="dollar_cost_2")
m.addConstr(13 * network_administrators + 4 * intrusion_analysts >= 55, name="dollar_cost_3")
m.addConstr(2 * patches_per_day + 8 * system_administrators >= 57, name="dollar_cost_4")
m.addConstr(2 * patches_per_day + 17 * deployed_decoys >= 39, name="dollar_cost_5")
m.addConstr(8 * system_administrators + 17 * deployed_decoys >= 42, name="dollar_cost_6")
m.addConstr(13 * network_administrators + 14 * security_engineers + 4 * intrusion_analysts >= 49, name="dollar_cost_7")
m.addConstr(14 * security_engineers + 8 * system_administrators + 17 * deployed_decoys >= 49, name="dollar_cost_8")
m.addConstr(2 * patches_per_day + 4 * intrusion_analysts + 8 * system_administrators >= 49, name="dollar_cost_9")
m.addConstr(14 * security_engineers + 2 * patches_per_day + 4 * intrusion_analysts >= 49, name="dollar_cost_10")
m.addConstr(2 * patches_per_day + 4 * intrusion_analysts + 17 * deployed_decoys >= 49, name="dollar_cost_11")
m.addConstr(13 * network_administrators + 8 * system_administrators + 17 * deployed_decoys >= 49, name="dollar_cost_12")

# Additional constraints
m.addConstr(-network_administrators + 7 * deployed_decoys >= 0, name="additional_1")
m.addConstr(-2 * patches_per_day + 3 * deployed_decoys >= 0, name="additional_2")
m.addConstr(4 * patches_per_day + 7 * intrusion_analysts - 2 * system_administrators >= 0, name="additional_3")

# Upper bounds on power consumption
m.addConstr(19 * patches_per_day + 10 * intrusion_analysts <= 414, name="upper_bound_1")
m.addConstr(4 * network_administrators + 10 * intrusion_analysts <= 139, name="upper_bound_2")
m.addConstr(4 * network_administrators + 19 * patches_per_day <= 189, name="upper_bound_3")
m.addConstr(19 * patches_per_day + 14 * deployed_decoys <= 520, name="upper_bound_4")
m.addConstr(19 * patches_per_day + 15 * system_administrators <= 151, name="upper_bound_5")
m.addConstr(10 * intrusion_analysts + 15 * system_administrators <= 389, name="upper_bound_6")
m.addConstr(4 * network_administrators + 14 * deployed_decoys <= 478, name="upper_bound_7")
m.addConstr(4 * network_administrators + 15 * system_administrators <= 212, name="upper_bound_8")
m.addConstr(2 * security_engineers + 10 * intrusion_analysts <= 258, name="upper_bound_9")
m.addConstr(15 * system_administrators + 14 * deployed_decoys <= 167, name="upper_bound_10")
m.addConstr(2 * security_engineers + 19 * patches_per_day + 10 * intrusion_analysts <= 106, name="upper_bound_11")
m.addConstr(19 * patches_per_day + 15 * system_administrators + 14 * deployed_decoys <= 378, name="upper_bound_12")

# Upper bounds on dollar cost
m.addConstr(13 * network_administrators + 14 * security_engineers <= 294, name="dollar_upper_bound_1")
m.addConstr(13 * network_administrators + 17 * deployed_decoys <= 136, name="dollar_upper_bound_2")
m.addConstr(2 * patches_per_day + 8 * system_administrators + 17 * deployed_decoys <= 424, name="dollar_upper_bound_3")
m.addConstr(13 * network_administrators + 8 * system_administrators + 17 * deployed_decoys <= 102, name="dollar_upper_bound_4")
m.addConstr(2 * patches_per_day + 4 * intrusion_analysts + 17 * deployed_decoys <= 244, name="dollar_upper_bound_5")
m.addConstr(14 * security_engineers + 2 * patches_per_day + 17 * deployed_decoys <= 328, name="dollar_upper_bound_6")
m.addConstr(14 * security_engineers + 2 * patches_per_day + 4 * intrusion_analysts <= 281, name="dollar_upper_bound_7")
m.addConstr(14 * security_engineers + 8 * system_administrators + 17 * deployed_decoys <= 229, name="dollar_upper_bound_8")
m.addConstr(13 * network_administrators + 4 * intrusion_analysts + 8 * system_administrators <= 351, name="dollar_upper_bound_9")
m.addConstr(14 * security_engineers + 4 * intrusion_analysts + 17 * deployed_decoys <= 135, name="dollar_upper_bound_10")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Network Administrators: ", network_administrators.varValue)
    print("Security Engineers: ", security_engineers.varValue)
    print("Patches per Day: ", patches_per_day.varValue)
    print("Intrusion Analysts: ", intrusion_analysts.varValue)
    print("System Administrators: ", system_administrators.varValue)
    print("Deployed Decoys: ", deployed_decoys.varValue)
else:
    print("The model is infeasible.")
