
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_optimization")

# Create variables
b4 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams of vitamin B4")
d = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams of vitamin D")

# Set objective function
model.setObjective(2 * b4**2 + 5 * b4, GRB.MINIMIZE)

# Add constraints
model.addConstr(b4 * 1 + d * 8 >= 16, "immune_support_min") # Corrected constraint
model.addConstr(10 * b4 - 10 * d >= 0, "b4_d_ratio")
model.addConstr(b4 * 1 + d * 8 <= 19, "immune_support_max") # Corrected constraint


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal value: {model.objVal}")
    print(f"Milligrams of vitamin B4: {b4.x}")
    print(f"Milligrams of vitamin D: {d.x}")

