
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Define variables
x0 = m.addVar(lb=-GRB.INFINITY, ub=GRB.INFINITY, name="milligrams_of_vitamin_B4")
x1 = m.addVar(lb=-GRB.INFINITY, ub=GRB.INFINITY, name="milligrams_of_vitamin_D")

# Objective function: Minimize 2*x0^2 + 5*x0
m.setObjective(2*x0**2 + 5*x0, GRB.MINIMIZE)

# Constraints
m.addConstr(x0**2 + 64*x1**2 >= 16, name="immune_support_index_squares")
m.addConstr(x0 + 8*x1 >= 16, name="total_immune_support_index_min")
m.addConstr(10*x0 - 10*x1 >= 0, name="vitamin_b4_vs_vitamin_d")
m.addConstr(x0 + 8*x1 <= 19, name="total_immune_support_index_max")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B4: {x0.x}")
    print(f"Milligrams of Vitamin D: {x1.x}")
else:
    print("No optimal solution found")
