
import gurobi

def optimize_vitamins():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="milligrams_of_vitamin_B4", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x1 = model.addVar(name="milligrams_of_vitamin_D", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(2*x0**2 + 5*x0, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x0**2 + x1**2 >= 16, name="constraint_1")
    model.addConstr(x0 + x1 >= 16, name="constraint_2")
    model.addConstr(10*x0 - 10*x1 >= 0, name="constraint_3")
    model.addConstr(x0 + x1 <= 19, name="constraint_4")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B4: {x0.varValue}")
        print(f"Milligrams of vitamin D: {x1.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_vitamins()
