
from gurobipy import Model, GRB, quicksum

# Create a new model
m = Model("optimization_problem")

# Create variables
hank = m.addVar(vtype=GRB.INTEGER, name="hank")
bill = m.addVar(vtype=GRB.INTEGER, name="bill")
jean = m.addVar(name="jean")
dale = m.addVar(name="dale")

# Set objective function
m.setObjective(1.77*hank*hank + 8.58*hank*bill + 2.9*hank*jean + 9.51*hank*dale + 5.01*bill*bill + 3.71*bill*jean + 3.57*bill*dale + 3.62*jean*dale + 4.16*dale*dale + 7.54*hank + 6.0*bill + 7.17*jean + 8.16*dale, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*bill + 3*dale >= 28, "c0")
m.addConstr(5*bill + 1*jean >= 24, "c1")
m.addConstr(1*jean*jean + 3*dale*dale >= 13, "c2")
m.addConstr(2*hank*hank + 5*bill*bill >= 23, "c3")
m.addConstr(2*hank*hank + 1*jean*jean + 3*dale*dale >= 19, "c4")
m.addConstr(2*hank*hank + 5*bill*bill + 3*dale*dale >= 19, "c5")
m.addConstr(2*hank*hank + 1*jean*jean + 3*dale*dale >= 28, "c6")
m.addConstr(2*hank + 5*bill + 3*dale >= 28, "c7")
m.addConstr(2*hank + 5*bill + 1*jean + 3*dale >= 28, "c8")
m.addConstr(8*bill + 1*jean >= 26, "c9")
m.addConstr(6*hank + 8*bill + 1*jean + 2*dale >= 26, "c10")
m.addConstr(-7*bill*bill + 1*dale*dale >= 0, "c11")
m.addConstr(5*bill + 1*jean <= 118, "c12")
m.addConstr(5*bill + 3*dale <= 69, "c13")
m.addConstr(8*bill*bill + 2*dale*dale <= 62, "c14")
m.addConstr(6*hank*hank + 2*dale*dale <= 98, "c15")
m.addConstr(6*hank + 8*bill + 2*dale <= 91, "c16")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

