
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
H_H = m.addVar(name="H_H", vtype=gp.GRB.INTEGER)
H_B = m.addVar(name="H_B", vtype=gp.GRB.INTEGER)
H_J = m.addVar(name="H_J")
H_D = m.addVar(name="H_D")

# Define the objective function
m.setObjective(1.77*H_H**2 + 8.58*H_H*H_B + 2.9*H_H*H_J + 9.51*H_H*H_D + 
               5.01*H_B**2 + 3.71*H_B*H_J + 3.57*H_B*H_D + 3.62*H_J*H_D + 
               4.16*H_D**2 + 7.54*H_H + 6.0*H_B + 7.17*H_J + 8.16*H_D, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2 * H_H <= 133)
m.addConstr(6 * H_H <= 104)
m.addConstr(5 * H_B <= 133)
m.addConstr(8 * H_B <= 104)
m.addConstr(1 * H_J <= 133)
m.addConstr(1 * H_J <= 104)
m.addConstr(3 * H_D <= 133)
m.addConstr(2 * H_D <= 104)
m.addConstr(5 * H_B + 3 * H_D >= 28)
m.addConstr(5 * H_B + 1 * H_J >= 24)
m.addConstr(1 * H_J**2 + 3 * H_D**2 >= 13)
m.addConstr(2 * H_H**2 + 5 * H_B**2 >= 23)
m.addConstr(2 * H_H**2 + 1 * H_J**2 + 3 * H_D**2 >= 19)
m.addConstr(2 * H_H**2 + 5 * H_B**2 + 3 * H_D**2 >= 19)
m.addConstr(2 * H_H**2 + 1 * H_J**2 + 3 * H_D**2 >= 28)
m.addConstr(2 * H_H + 5 * H_B + 3 * H_D >= 28)
m.addConstr(2 * H_H + 5 * H_B + 1 * H_J + 3 * H_D >= 28)
m.addConstr(8 * H_B + 1 * H_J >= 26)
m.addConstr(6 * H_H + 8 * H_B + 1 * H_J + 2 * H_D >= 26)
m.addConstr(-7 * H_B**2 + 1 * H_D**2 >= 0)
m.addConstr(5 * H_B + 1 * H_J <= 118)
m.addConstr(5 * H_B + 3 * H_D <= 69)
m.addConstr(8 * H_B**2 + 2 * H_D**2 <= 62)
m.addConstr(6 * H_H**2 + 2 * H_D**2 <= 98)
m.addConstr(6 * H_H + 8 * H_B + 2 * H_D <= 91)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("H_H: ", H_H.varValue)
    print("H_B: ", H_B.varValue)
    print("H_J: ", H_J.varValue)
    print("H_D: ", H_D.varValue)
else:
    print("The model is infeasible")
