
from gurobipy import Model, GRB

# Create a new model
m = Model("food_optimization")

# Create variables
bananas = m.addVar(vtype=GRB.INTEGER, name="bananas")
eggs = m.addVar(vtype=GRB.CONTINUOUS, name="eggs")
apple_pies = m.addVar(vtype=GRB.CONTINUOUS, name="apple_pies")

# Set objective function
m.setObjective(3.99 * bananas + 4.83 * eggs + 2.67 * apple_pies, GRB.MINIMIZE)

# Add constraints
m.addConstr(29 * bananas + 1 * apple_pies >= 52, "fat_constraint1")
m.addConstr(29 * bananas + 15 * eggs >= 35, "fat_constraint2")
m.addConstr(15 * eggs + 1 * apple_pies >= 29, "fat_constraint3")
m.addConstr(29 * bananas + 15 * eggs + 1 * apple_pies >= 44, "fat_constraint4")
m.addConstr(28 * bananas + 8 * apple_pies >= 33, "calcium_constraint1")
m.addConstr(28 * bananas + 28 * eggs >= 60, "calcium_constraint2")
m.addConstr(28 * bananas + 28 * eggs + 8 * apple_pies >= 60, "calcium_constraint3")
m.addConstr(24 * bananas + 25 * apple_pies >= 119, "umami_constraint1")
m.addConstr(24 * bananas + 5 * eggs >= 83, "umami_constraint2")
m.addConstr(24 * bananas + 5 * eggs + 25 * apple_pies >= 117, "umami_constraint3")
m.addConstr(8 * bananas + 23 * eggs >= 76, "carbs_constraint1")
m.addConstr(23 * eggs + 20 * apple_pies >= 71, "carbs_constraint2")
m.addConstr(8 * bananas + 23 * eggs + 20 * apple_pies >= 71, "carbs_constraint3")
m.addConstr(6 * bananas - 4 * eggs >= 0, "constraint1")
m.addConstr(6 * eggs - 9 * apple_pies >= 0, "constraint2")
m.addConstr(29 * bananas + 15 * eggs <= 160, "fat_constraint5")
m.addConstr(29 * bananas + 1 * apple_pies <= 68, "fat_constraint6")
m.addConstr(28 * bananas + 8 * apple_pies <= 190, "calcium_constraint4")
m.addConstr(28 * bananas + 28 * eggs <= 85, "calcium_constraint5")
m.addConstr(28 * eggs + 8 * apple_pies <= 109, "calcium_constraint6")
m.addConstr(8 * bananas + 23 * eggs <= 150, "carbs_constraint4")
m.addConstr(8 * bananas + 23 * eggs + 20 * apple_pies <= 310, "carbs_constraint5")


# Resource Constraints (upper bounds)
m.addConstr(29 * bananas + 15 * eggs + 1 * apple_pies <= 160, "total_fat")
m.addConstr(28 * bananas + 28 * eggs + 8 * apple_pies <= 210, "total_calcium")
m.addConstr(24 * bananas + 5 * eggs + 25 * apple_pies <= 365, "total_umami")
m.addConstr(8 * bananas + 23 * eggs + 20 * apple_pies <= 348, "total_carbs")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('bananas:', bananas.x)
    print('eggs:', eggs.x)
    print('apple_pies:', apple_pies.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

