
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
bananas = m.addVar(name="bananas", lb=0, type=gp.GRB.INTEGER)  # integer
eggs = m.addVar(name="eggs", lb=0)  # continuous
apple_pies = m.addVar(name="apple_pies", lb=0)  # continuous

# Objective function
m.setObjective(3.99 * bananas + 4.83 * eggs + 2.67 * apple_pies, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(29 * bananas + 15 * eggs + apple_pies <= 160)  # fat
m.addConstr(28 * bananas + 28 * eggs + 8 * apple_pies <= 210)  # calcium
m.addConstr(24 * bananas + 5 * eggs + 25 * apple_pies <= 365)  # umami index
m.addConstr(8 * bananas + 23 * eggs + 20 * apple_pies <= 348)  # carbohydrates

m.addConstr(29 * bananas + apple_pies >= 52)  # fat from bananas and apple pies
m.addConstr(29 * bananas + 15 * eggs >= 35)  # fat from bananas and eggs
m.addConstr(15 * eggs + apple_pies >= 29)  # fat from eggs and apple pies
m.addConstr(29 * bananas + 15 * eggs + apple_pies >= 44)  # total fat

m.addConstr(28 * bananas + 8 * apple_pies >= 33)  # calcium from bananas and apple pies
m.addConstr(28 * bananas + 28 * eggs >= 60)  # calcium from bananas and eggs
m.addConstr(28 * bananas + 28 * eggs + 8 * apple_pies >= 60)  # total calcium

m.addConstr(24 * bananas + 25 * apple_pies >= 119)  # umami from bananas and apple pies
m.addConstr(24 * bananas + 5 * eggs >= 83)  # umami from bananas and eggs
m.addConstr(24 * bananas + 5 * eggs + 25 * apple_pies >= 117)  # total umami

m.addConstr(8 * bananas + 23 * eggs >= 76)  # carbohydrates from bananas and eggs
m.addConstr(23 * eggs + 20 * apple_pies >= 71)  # carbohydrates from eggs and apple pies
m.addConstr(8 * bananas + 23 * eggs + 20 * apple_pies >= 71)  # total carbohydrates

m.addConstr(6 * bananas - 4 * eggs >= 0)
m.addConstr(6 * eggs - 9 * apple_pies >= 0)

m.addConstr(29 * bananas + 15 * eggs <= 160)  # fat from bananas and eggs
m.addConstr(29 * bananas + apple_pies <= 68)  # fat from bananas and apple pies
m.addConstr(28 * bananas + 8 * apple_pies <= 190)  # calcium from bananas and apple pies
m.addConstr(28 * bananas + 28 * eggs <= 85)  # calcium from bananas and eggs
m.addConstr(28 * eggs + 8 * apple_pies <= 109)  # calcium from eggs and apple pies
m.addConstr(8 * bananas + 23 * eggs <= 150)  # carbohydrates from bananas and eggs
m.addConstr(8 * bananas + 23 * eggs + 20 * apple_pies <= 310)  # total carbohydrates

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Bananas: {bananas.varValue}")
    print(f"Eggs: {eggs.varValue}")
    print(f"Apple pies: {apple_pies.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
