
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
bagged_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bagged_salads")
tomatoes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="tomatoes")
cornichons = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cornichons")

# Set objective function
m.setObjective(6 * bagged_salads + 6 * tomatoes + 3 * cornichons, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * bagged_salads + 3 * cornichons >= 59, "c1")
m.addConstr(20 * tomatoes + 3 * cornichons >= 56, "c2")
m.addConstr(8 * bagged_salads + 20 * tomatoes + 3 * cornichons >= 56, "c3")
m.addConstr(4 * bagged_salads + 4 * tomatoes >= 58, "c4")
m.addConstr(4 * bagged_salads + 4 * cornichons >= 87, "c5")
m.addConstr(4 * tomatoes + 4 * cornichons >= 33, "c6")
m.addConstr(4 * bagged_salads + 4 * tomatoes + 4 * cornichons >= 33, "c7")
m.addConstr(-6 * tomatoes + 4 * cornichons >= 0, "c8")
m.addConstr(-6 * bagged_salads + 5 * cornichons >= 0, "c9")
m.addConstr(8 * bagged_salads + 20 * tomatoes + 3 * cornichons <= 184, "c10")  # Healthiness upper bound
m.addConstr(4 * bagged_salads + 4 * tomatoes <= 155, "c11")  # Fiber upper bound (bagged salads and tomatoes)
m.addConstr(4 * tomatoes + 4 * cornichons <= 107, "c12")  # Fiber upper bound (tomatoes and cornichons)
m.addConstr(4 * bagged_salads + 4 * tomatoes + 4 * cornichons <= 178, "c13")  # Fiber upper bound (all)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('bagged_salads:', bagged_salads.x)
    print('tomatoes:', tomatoes.x)
    print('cornichons:', cornichons.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

