
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
bagged_salads = m.addVar(name="bagged_salads", lb=0)
tomatoes = m.addVar(name="tomatoes", lb=0)
cornichons = m.addVar(name="cornichons", lb=0)

# Objective function
m.setObjective(6 * bagged_salads + 6 * tomatoes + 3 * cornichons, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(8 * bagged_salads + 3 * cornichons >= 59)
m.addConstr(20 * tomatoes + 3 * cornichons >= 56)
m.addConstr(8 * bagged_salads + 20 * tomatoes + 3 * cornichons >= 56)

m.addConstr(4 * bagged_salads + 4 * tomatoes >= 58)
m.addConstr(4 * bagged_salads + 4 * cornichons >= 87)
m.addConstr(4 * tomatoes + 4 * cornichons >= 33)
m.addConstr(4 * bagged_salads + 4 * tomatoes + 4 * cornichons >= 33)

m.addConstr(8 * bagged_salads + 20 * tomatoes + 3 * cornichons <= 184)
m.addConstr(4 * bagged_salads + 4 * tomatoes <= 155)
m.addConstr(4 * tomatoes + 4 * cornichons <= 107)
m.addConstr(4 * bagged_salads + 4 * tomatoes + 4 * cornichons <= 178)

m.addConstr(-6 * tomatoes + 4 * cornichons >= 0)
m.addConstr(-6 * bagged_salads + 5 * cornichons >= 0)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Bagged Salads: ", bagged_salads.varValue)
    print("Tomatoes: ", tomatoes.varValue)
    print("Cornichons: ", cornichons.varValue)
else:
    print("The model is infeasible")
