
from gurobipy import *

# Create a new model
m = Model("Nutrition")

# Define variables
vitamin_b4 = m.addVar(lb=0, name="Vitamin B4")
protein = m.addVar(lb=0, name="Protein")
iron = m.addVar(lb=0, name="Iron")
magnesium = m.addVar(lb=0, name="Magnesium")
vitamin_b7 = m.addVar(lb=0, name="Vitamin B7")
vitamin_b5 = m.addVar(lb=0, name="Vitamin B5")
vitamin_d = m.addVar(lb=0, name="Vitamin D")

# Define constraints
m.addConstr(vitamin_b4 + protein >= 100, "Energy_Stability_1")
m.addConstr(iron + magnesium >= 50, "Energy_Stability_2")
m.addConstr(vitamin_b7 + vitamin_d >= 20, "Energy_Stability_3")

# Define digestive support constraints
m.addConstr(vitamin_b4 + protein <= 511, "Digestive_Support_1")
m.addConstr(iron + vitamin_b7 <= 134, "Digestive_Support_2")
m.addConstr(vitamin_b4 + vitamin_b7 <= 479, "Digestive_Support_3")

# Define cardiovascular support constraints
m.addConstr(protein + magnesium <= 391, "Cardiovascular_Support_1")
m.addConstr(iron + vitamin_d <= 402, "Cardiovascular_Support_2")

# Define objective function
m.setObjective(vitamin_b4 + protein + iron + magnesium + vitamin_b7 + vitamin_b5 + vitamin_d, GRB.MINIMIZE)

# Optimize model
m.optimize()

print("Vitamin B4:", vitamin_b4.x)
print("Protein:", protein.x)
print("Iron:", iron.x)
print("Magnesium:", magnesium.x)
print("Vitamin B7:", vitamin_b7.x)
print("Vitamin B5:", vitamin_b5.x)
print("Vitamin D:", vitamin_d.x)
