
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define variables
x0 = m.addVar(lb=0, name="milligrams of vitamin B4")
x1 = m.addVar(lb=0, name="grams of protein")
x2 = m.addVar(lb=0, name="milligrams of iron")
x3 = m.addVar(lb=0, name="milligrams of magnesium")
x4 = m.addVar(lb=0, name="milligrams of vitamin B7")
x5 = m.addVar(lb=0, name="milligrams of vitamin B5")
x6 = m.addVar(lb=0, name="milligrams of vitamin D")

# Objective function
m.setObjective(5.14*x0 + 9.45*x1 + 8.47*x2 + 2.88*x3 + 1.77*x4 + 8.7*x5 + 7.57*x6, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(25*x0 + 2*x1 + 23*x2 + 2*x3 + 3*x4 + 24*x5 + 11*x6 <= 812)
m.addConstr(24*x0 + 6*x1 + 10*x2 + 15*x3 + 5*x4 + 23*x5 + 8*x6 <= 386)
m.addConstr(23*x0 + x1 + 5*x2 + 15*x3 + 24*x4 + 10*x5 + 12*x6 <= 764)
m.addConstr(25*x0 + 8*x1 + 23*x2 + 20*x3 + 22*x4 + 6*x5 + 17*x6 <= 809)

m.addConstr(2*x1 + 3*x4 >= 47)
m.addConstr(25*x0 + 3*x4 + 24*x5 >= 97)
m.addConstr(23*x2 + 2*x3 + 24*x5 >= 97)
m.addConstr(2*x3 + 3*x4 + 24*x5 >= 97)
m.addConstr(x1 + 3*x4 + 24*x5 >= 97)
m.addConstr(23*x2 + 2*x3 + x6 >= 97)
m.addConstr(2*x1 + 23*x2 + 3*x4 >= 97)
m.addConstr(25*x0 + 2*x1 + 2*x3 >= 97)
m.addConstr(2*x1 + 23*x2 + 24*x5 >= 97)
m.addConstr(25*x0 + 23*x2 + 24*x5 >= 97)
m.addConstr(25*x0 + x1 + 12*x6 >= 97)
m.addConstr(2*x3 + 3*x4 + x6 >= 97)
m.addConstr(25*x0 + 23*x2 + x6 >= 97)
m.addConstr(25*x0 + x1 + 24*x5 >= 97)
m.addConstr(25*x0 + 3*x4 + 24*x5 >= 77)
m.addConstr(23*x2 + 2*x3 + 24*x5 >= 77)
m.addConstr(2*x3 + 3*x4 + 24*x5 >= 77)
m.addConstr(x1 + 3*x4 + 24*x5 >= 77)
m.addConstr(23*x2 + 2*x3 + x6 >= 77)
m.addConstr(2*x1 + 23*x2 + 3*x4 >= 77)
m.addConstr(25*x0 + 2*x1 + 2*x3 >= 77)
m.addConstr(2*x1 + 23*x2 + 24*x5 >= 77)
m.addConstr(25*x0 + 23*x2 + 24*x5 >= 77)
m.addConstr(25*x0 + x1 + 12*x6 >= 77)
m.addConstr(2*x3 + 3*x4 + x6 >= 77)
m.addConstr(25*x0 + 23*x2 + x6 >= 77)
m.addConstr(25*x0 + x1 + 24*x5 >= 78)
m.addConstr(23*x2 + 2*x3 + 24*x5 >= 78)
m.addConstr(2*x3 + 3*x4 + 24*x5 >= 78)
m.addConstr(x1 + 3*x4 + 24*x5 >= 78)
m.addConstr(23*x2 + 2*x3 + x6 >= 78)
m.addConstr(2*x1 + 23*x2 + 3*x4 >= 78)
m.addConstr(25*x0 + 2*x1 + 2*x3 >= 78)
m.addConstr(2*x1 + 23*x2 + 24*x5 >= 78)
m.addConstr(25*x0 + 23*x2 + 24*x5 >= 78)
m.addConstr(25*x0 + x1 + 12*x6 >= 78)
m.addConstr(2*x3 + 3*x4 + x6 >= 78)
m.addConstr(25*x0 + 23*x2 + x6 >= 78)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Milligrams of vitamin B4: ", x0.varValue)
    print("Grams of protein: ", x1.varValue)
    print("Milligrams of iron: ", x2.varValue)
    print("Milligrams of magnesium: ", x3.varValue)
    print("Milligrams of vitamin B7: ", x4.varValue)
    print("Milligrams of vitamin B5: ", x5.varValue)
    print("Milligrams of vitamin D: ", x6.varValue)
else:
    print("The model is infeasible")
