
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
x = {}
x[0] = m.addVar(vtype=gp.GRB.INTEGER, name="automatic_alerts")
x[1] = m.addVar(vtype=gp.GRB.INTEGER, name="network_administrators")
x[2] = m.addVar(vtype=gp.GRB.INTEGER, name="security_engineers")
x[3] = m.addVar(vtype=gp.GRB.INTEGER, name="Mbps_bandwidth_allocated_to_monitoring")
x[4] = m.addVar(vtype=gp.GRB.INTEGER, name="system_administrators")


# Set objective function
m.setObjective(3*x[0] + 1*x[1] + 6*x[2] + 9*x[3] + 9*x[4], gp.GRB.MAXIMIZE)

# Resource constraints
resources = {
    'r0': {'upper_bound': 321, 'coefficients': [16, 7, 15, 17, 1]},
    'r1': {'upper_bound': 331, 'coefficients': [5, 7, 16, 6, 4]}
}

for r_name, r_data in resources.items():
    m.addConstr(
        gp.quicksum(r_data['coefficients'][i] * x[i] for i in range(5)) <= r_data['upper_bound'],
        name=f"{r_name}_constraint"
    )

# Additional constraints
m.addConstr(15*x[2] + 1*x[4] >= 29, "c1")
m.addConstr(16*x[0] + 7*x[1] >= 49, "c2")
m.addConstr(16*x[0] + 17*x[3] >= 44, "c3")
m.addConstr(7*x[1] + 17*x[3] >= 32, "c4")
m.addConstr(16*x[0] + 1*x[4] >= 63, "c5")
m.addConstr(16*x[0] + 15*x[2] >= 23, "c6")
m.addConstr(7*x[1] + 15*x[2] >= 35, "c7")
m.addConstr(15*x[2] + 17*x[3] >= 59, "c8")
m.addConstr(16*x[0] + 15*x[2] + 17*x[3] >= 37, "c9")
m.addConstr(16*x[0] + 17*x[3] + 1*x[4] >= 37, "c10")
m.addConstr(16*x[0] + 7*x[1] + 15*x[2] >= 37, "c11")
m.addConstr(16*x[0] + 7*x[1] + 17*x[3] >= 37, "c12")

# ... (Rest of the constraints -  Follow the same pattern as above)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

