
from gurobipy import Model, GRB

# Create a new model
model = Model("Maximize Output")

# Create variables
bill_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Bill Hours")  # Bill's hours (continuous)
jean_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="Jean Hours")  # Jean's hours (integer)

# Set objective function
model.setObjective(7.94 * bill_hours + 3.2 * jean_hours, GRB.MAXIMIZE)

# Add constraints
model.addConstr(6 * bill_hours + 12 * jean_hours >= 15, "Minimum Combined Cost")
model.addConstr(-6 * bill_hours + 3 * jean_hours >= 0, "Bill-Jean Relationship")
model.addConstr(6 * bill_hours + 12 * jean_hours <= 42, "Maximum Combined Cost")
# Redundant constraint, already captured by the previous one
# model.addConstr(6 * bill_hours + 12 * jean_hours == 42, "Exact Combined Cost")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Bill's Hours: {bill_hours.x}")
    print(f"Jean's Hours: {jean_hours.x}")
    print(f"Objective Value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

