
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
hours_worked_by_Bill = m.addVar(lb=0, name="hours_worked_by_Bill")
hours_worked_by_Jean = m.addVar(vtype=GRB.INTEGER, lb=0, name="hours_worked_by_Jean")

# Objective function: Maximize 7.94 * hours_worked_by_Bill + 3.2 * hours_worked_by_Jean
m.setObjective(7.94 * hours_worked_by_Bill + 3.2 * hours_worked_by_Jean, GRB.MAXIMIZE)

# Constraints
m.addConstr(6 * hours_worked_by_Bill + 12 * hours_worked_by_Jean >= 15, name="total_cost_lower_bound")
m.addConstr(-6 * hours_worked_by_Bill + 3 * hours_worked_by_Jean >= 0, name="linear_constraint")
m.addConstr(6 * hours_worked_by_Bill + 12 * hours_worked_by_Jean <= 42, name="total_cost_upper_bound")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Bill: {hours_worked_by_Bill.x}")
    print(f"Hours worked by Jean: {hours_worked_by_Jean.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
